DELIMITER $$
DROP PROCEDURE IF EXISTS V20230228174554__Create_ProofOfActivityTable $$
CREATE PROCEDURE V20230228174554__Create_ProofOfActivityTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='proof_of_activity')) THEN 
CREATE TABLE `proof_of_activity`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint(20) NOT NULL,
`researchActivity` bigint(20) NOT NULL,
`researchActivityName` varchar(100) DEFAULT NULL,
`researchActivityDate` date NOT NULL,
`auditDate` date NOT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_proofOfActivity_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_proofOfActivity_SU_researchActivity` FOREIGN KEY (`researchActivity`) REFERENCES `research_activity` (`id`),
CONSTRAINT `FK_proofOfActivity_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_proofOfActivity_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;

END IF; 

END $$
CALL V20230228174554__Create_ProofOfActivityTable () $$ 
DROP PROCEDURE IF EXISTS V20230228174554__Create_ProofOfActivityTable $$ 
DELIMITER ;