DELIMITER $$
DROP PROCEDURE IF EXISTS V20230228175025__Create_ProofOfActivityDocumentTable $$
CREATE PROCEDURE V20230228175025__Create_ProofOfActivityDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='proof_of_activity_document')) THEN 
CREATE TABLE `proof_of_activity_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `proofOfActivityId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `proof_of_activity_document_FK` FOREIGN KEY (`proofOfActivityId`) REFERENCES proof_of_activity(`id`),
  CONSTRAINT `proof_of_activity_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `proof_of_activity_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF;

END $$
CALL V20230228175025__Create_ProofOfActivityDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20230228175025__Create_ProofOfActivityDocumentTable $$ 
DELIMITER ;