DELIMITER $$
DROP PROCEDURE IF EXISTS V20230404095938__Create_ExamStudentYearlyAvg $$
CREATE PROCEDURE V20230404095938__Create_ExamStudentYearlyAvg()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_student_yearly_average')) THEN 
CREATE TABLE exam_student_yearly_average (
  id bigint NOT NULL AUTO_INCREMENT,
  admissionId  bigint NOT NULL,
  programId  bigint NOT NULL,
  batchId  bigint NOT NULL,
  periodYearId bigint NOT NULL,
  yearlyAverage bigint,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_admissionId_idx (admissionId),
  KEY fk_programId_idx (programId),
  KEY fk_batchId_idx (batchId),
  KEY fk_periodYearId_idx (periodYearId),
  KEY fk_exam_student_yearly_average_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_esya_admission_admissionId FOREIGN KEY (admissionId) REFERENCES admission (id),
  CONSTRAINT fk_esya_programs_programId FOREIGN KEY (programId) REFERENCES programs (id),
  CONSTRAINT fk_esya_batches_batchId FOREIGN KEY (batchId) REFERENCES batches (id),
  CONSTRAINT fk_esya_periodYear_periodYearId FOREIGN KEY (periodYearId) REFERENCES period_year (id),
  CONSTRAINT fk_exam_student_yearly_average_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20230404095938__Create_ExamStudentYearlyAvg () $$ 
DROP PROCEDURE IF EXISTS V20230404095938__Create_ExamStudentYearlyAvg $$ 
DELIMITER ;