DELIMITER $$
DROP PROCEDURE IF EXISTS V20230404101406__Create_ExamStudentProgramAvg $$
CREATE PROCEDURE V20230404101406__Create_ExamStudentProgramAvg()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_student_program_average')) THEN 
CREATE TABLE exam_student_program_average (
  id bigint NOT NULL AUTO_INCREMENT,
  admissionId  bigint NOT NULL,
  programId  bigint NOT NULL,
  batchId  bigint NOT NULL,
  programAverage bigint,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_admissionId_idx (admissionId),
  KEY fk_programId_idx (programId),
  KEY fk_batchId_idx (batchId),
  KEY fk_exam_student_program_average_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_espa_admissions_admissionId FOREIGN KEY (admissionId) REFERENCES admission (id),
  CONSTRAINT fk_espa_program_programId FOREIGN KEY (programId) REFERENCES programs (id),
  CONSTRAINT fk_espa_batches_batchId FOREIGN KEY (batchId) REFERENCES batches (id),
  CONSTRAINT fk_exam_student_program_average_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20230404101406__Create_ExamStudentProgramAvg () $$ 
DROP PROCEDURE IF EXISTS V20230404101406__Create_ExamStudentProgramAvg $$ 
DELIMITER ;