DELIMITER $$
DROP PROCEDURE IF EXISTS V20230516181842__Update_GradeBookPublishRecipent $$
CREATE PROCEDURE V20230516181842__Update_GradeBookPublishRecipent()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT')) THEN 
SET @enqVelRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PUBLISH_GRADE_BOOK_FOR_STUDENTS_RECIPIENT');
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
  T12.`id` AS ID,
       T3.`firstName` AS FIRST_NAME,
       T3.`printName` AS STUDENT_PRINT_NAME,
       T3.`emailId` AS EMAIL_ID,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T8.`programName` AS PROGRAM_NAME,
       T10.`batchName` AS BATCH_NAME,
       T11.`programPeriodName` AS PERIOD_NAME
   FROM
   examination_report_document T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            students as T2 on T2.userId=T1.studentId
            left join 
            persons as T3 on T3.id=T2.personId
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join 
            programs T8 on T8.id=T1.programId
  		   left join 
            prog_batch_period_config T11 on T11.id=T12.periodId
            left join
            batches T10 on T10.id=T11.programBatchId
   WHERE
       T12.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
        "searchResultViewColumns": [
 		 {
             "id": 1,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 0
         },
        {
             "id": 2,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 1
         },
         {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	    },
        {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	    },
 	    
 	     {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
         },
         {
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         }
 	
 ]
}' WHERE (`dataProviderId` = @enqVelRecId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230516181842__Update_GradeBookPublishRecipent () $$
DROP PROCEDURE IF EXISTS V20230516181842__Update_GradeBookPublishRecipent $$
DELIMITER ;