DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726130239__Create_Student_Health_DropDown $$
CREATE PROCEDURE V20230726130239__Create_Student_Health_DropDown()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_medical_condition')) THEN 
CREATE TABLE `student_health_medical_condition` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`medicalConditionId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_student_health_medical_condition_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `student_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_student_health_medical_condition_medicalConditionId_idx` FOREIGN KEY (`medicalConditionId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_medication')) THEN
CREATE TABLE `student_health_medication` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`medicationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_student_health_medication_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `student_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_student_health_medication_medicationId_idx` FOREIGN KEY (`medicationId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_allergies')) THEN
CREATE TABLE `student_health_allergies` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`allergieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_student_health_allergies_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `student_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_student_health_allergies_allergieId_idx` FOREIGN KEY (`allergieId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_learning_difficulties')) THEN
CREATE TABLE `student_health_learning_difficulties` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`learningDifficultieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_student_health_learning_difficulties_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `student_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_student_health_learning_difficultiesId_idx` FOREIGN KEY (`learningDifficultieId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230726130239__Create_Student_Health_DropDown () $$ 
DROP PROCEDURE IF EXISTS V20230726130239__Create_Student_Health_DropDown $$ 
DELIMITER ;