DELIMITER $$
DROP PROCEDURE IF EXISTS `flag_data_for_job` $$
CREATE PROCEDURE `flag_data_for_job`()
BEGIN
SELECT 
    this.id AS id,
    br.id AS businessRuleId,
    this.flagCode as flagCode,
    br.codeValue AS businessRuleCode,
    this.scheduleType AS scheduleType,
    this.scheduleValue AS scheduleValue,
    this.whetherSchedule AS whetherSchedule,
    this.flagStatus AS flagStatus,
    this.approveStatus AS approveStatus,
    this.isInitiated as isInitiated,
    br.approvalStatus AS approvalStatus,
    br.businessRuleStatus AS businessRuleStatus
    
FROM
    flag this
        JOIN
    business_rule br ON br.id = this.businessRuleId
WHERE
            this.flagStatus IS TRUE
        AND this.approveStatus IS TRUE
        AND br.approvalStatus IS TRUE
        AND br.businessRuleStatus IS TRUE
        AND ((this.isInitiated IS TRUE
        AND (this.endDate >= NOW()
        OR this.endDate IS NULL)));
END$$
DELIMITER ;
