DELIMITER $$
DROP PROCEDURE IF EXISTS V20230727142741__Create_HostelAplicationSetup $$
CREATE PROCEDURE V20230727142741__Create_HostelAplicationSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_application_setup')) THEN 
CREATE TABLE `hostel_application_setup` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`userType` varchar(150) NOT NULL,
`applicationDroolRule` varchar(255) DEFAULT NULL,
`setupName` varchar(255) DEFAULT NULL,
`setupCode` varchar(255) DEFAULT NULL,
`applicationStartDate` date DEFAULT NULL,
`applicationEndDate` date DEFAULT NULL,
`hostelSetupType` varchar(150) NOT NULL,
`offerApplicable` bit(1) DEFAULT FALSE,
`offerLetterStartDate` date DEFAULT NULL,
`offerLetterEndDate` date DEFAULT NULL,
`maxDaysToAcceptOffer` bigint(20) DEFAULT NULL,
`academyLocationId` bigint(20) NOT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
);
	
END IF; 

END $$
CALL V20230727142741__Create_HostelAplicationSetup () $$ 
DROP PROCEDURE IF EXISTS V20230727142741__Create_HostelAplicationSetup $$ 
DELIMITER ;