DELIMITER $$
DROP PROCEDURE IF EXISTS V20230906185016__Create_Table_EnrollmentStatusSetting $$
CREATE PROCEDURE V20230906185016__Create_Table_EnrollmentStatusSetting()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enrollment_status_setting')) THEN 

CREATE TABLE `enrollment_status_setting` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`enrollmentStatus` VARCHAR(100) NOT NULL,
	`isVisible` BIT(1) DEFAULT 0,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	
    KEY fk_enrollment_status_setting_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_enrollment_status_setting_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF;  

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enrollment_status_setting')) THEN
INSERT INTO `enrollment_status_setting`(`enrollmentStatus`,`isVisible`,`lastUpdatedBy`,`lastUpdate`) 
VALUES ('REGULAR',0,1,now()),('OUT_OF_SEQUENCE',0,1,now()),('PROGRAM_TRANSFER',0,1,now()),('EXCHANGE_SEMESTER',0,1,now()),('LEAVE_OF_ABSENCE',0,1,now()),('DIRECT_ENTRY',0,1,now()),('RETAKE_OF_A_SEMESTER',0,1,now());
END IF;

END $$
CALL V20230906185016__Create_Table_EnrollmentStatusSetting () $$ 
DROP PROCEDURE IF EXISTS V20230906185016__Create_Table_EnrollmentStatusSetting $$ 
DELIMITER ;