DELIMITER $$
DROP PROCEDURE IF EXISTS V20231004142336__Create_hostelCapacity_Main $$
CREATE PROCEDURE V20231004142336__Create_hostelCapacity_Main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_capacity')) THEN 
CREATE TABLE `hostel_capacity` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`academicTermId` bigint default null,
    `hostelId` bigint DEFAULT NULL,
    `hostelCode` varchar(255) DEFAULT NULL,
    `hostelName` varchar(255) DEFAULT NULL,
	`totalCapacity` bigint DEFAULT NULL,
	`totalCapacityOccupied` bigint DEFAULT NULL,
	`totalCapacityLeft` bigint DEFAULT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    CONSTRAINT FK_hostelID_hostelCapacity FOREIGN KEY (hostelId) references resources(id),
    CONSTRAINT FK_academictermID_hostelCapacity FOREIGN KEY (academicTermId) references academic_term(id),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20231004142336__Create_hostelCapacity_Main () $$ 
DROP PROCEDURE IF EXISTS V20231004142336__Create_hostelCapacity_Main $$ 
DELIMITER ;