DELIMITER $$
DROP PROCEDURE IF EXISTS V20231226154531__Create_StudentAdmissionApprover $$
CREATE PROCEDURE V20231226154531__Create_StudentAdmissionApprover()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_admission_approver')) THEN 
CREATE TABLE `student_admission_approver`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint(20) NOT NULL,
`programBatchSeatConfigId` bigint(20) NOT NULL,
`admissionApproverId` bigint(20) DEFAULT NULL,
`secondApproverId` bigint(20) DEFAULT NULL,
`status` varchar(100) DEFAULT NULL,
`reasonId` bigint(20) DEFAULT NULL,
`inspectionDate` TIMESTAMP DEFAULT NULL,
`comment` varchar(255) DEFAULT NULL,
`thirdApproverId` bigint(20) DEFAULT NULL,
`thirdStatus` varchar(100) DEFAULT NULL,
`thirdReasonId` bigint(20) DEFAULT NULL,
`thirdInspectionDate` TIMESTAMP DEFAULT NULL,
`thirdComment` varchar(255) DEFAULT NULL,
`actioned` boolean DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_personId_stdAdmApp` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_programBatchSeatConfigId_stdAdmApp` FOREIGN KEY (`programBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`),
CONSTRAINT `FK_admissionApproverId_stdAdmApp` FOREIGN KEY (`admissionApproverId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_secondApproverId_stdAdmApp` FOREIGN KEY (`secondApproverId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_thirdApproverId_stdAdmApp` FOREIGN KEY (`thirdApproverId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_reasonId_stdAdmApp` FOREIGN KEY (`reasonId`) REFERENCES `drop_down` (`id`),
CONSTRAINT `FK_thirdReasonId_stdAdmApp` FOREIGN KEY (`thirdReasonId`) REFERENCES `drop_down` (`id`),
CONSTRAINT `FK_lastUpdatedBy_stdAdmApp` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)

 ) ;

END IF; 


END $$
CALL V20231226154531__Create_StudentAdmissionApprover () $$ 
DROP PROCEDURE IF EXISTS V20231226154531__Create_StudentAdmissionApprover $$ 
DELIMITER ;