DELIMITER $$
DROP PROCEDURE IF EXISTS V20240104122606__Update_UpdateRegistrationConfirmationLater $$
CREATE PROCEDURE V20240104122606__Update_UpdateRegistrationConfirmationLater()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO' limit 1)) THEN 
update dydt_data_line_item set resultColumnsDef  ='APP_USERNAME,APP_FIRST_NAME,APP_MIDDLE_NAME,APP_LAST_NAME,APP_EMAIL_ID,
 APP_MOBILE_NO,APP_MOBILE_CODE,APP_PASSWORD,APP_PROGRAM_NAME,APP_INTAKE_NAME,APP_PERIOD_NAME,APP_STUDENT_ID,
 APP_ACADEMIC_TERM,APP_INTAKE_YEAR,APP_MODE_OF_DELIVERY,APP_REGISTRATION_TYPE,APP_INTAKE_START_DATE,
 APP_INTAKE_END_DATE,APP_ACADEMY_NAME,APP_LOCATION_NAME,APP_ACADEMY_LOCATION,APP_SEAT_TYPE,APP_PHONE_COUNTRY_CODE,APP_PHONE_AREA_CODE,
 APP_PHONE_NO,APP_CAMPUS_EMAILID,APP_CAMPUS_WEBSITE_URL,APP_STD_ADDRESS,APP_NATIONAL_ID,APP_ID_TYPE,APP_TITLE,APP_CAST_CATEGORY,APP_NATIONALITY,
 APP_HOME_LANGUAGE,APP_ADMISSION_DATE,APP_CURRENT_ADDRESS,APP_COUNTRY_NAME_STUDENT,APP_COUNTRY_REGION_STUDENT,APP_CITY_STUDENT,APP_POSTAL_CODE, APP_PAYMENT_TERM,APP_REQUEST_RECEIVED_DATE,APP_EXAM_CENTER',
sqlSelectQueryDef =  "SELECT DISTINCT
    T3.userId AS ID,
    T17.printName AS APP_USERNAME,
    T18.firstName AS APP_FIRST_NAME,
    T18.middleName AS APP_MIDDLE_NAME,
    T18.lastName AS APP_LAST_NAME,
    g.itemValue AS APP_GENDER,
    T18.emailId AS APP_EMAIL_ID,
    T18.alternateEmailId AS APP_ALTERNATE_EMAIL_ID,
    T18.birthDate AS APP_DATE_OF_BIRTH,
    T18.alternateMobileNo AS APP_ALTERNATE_MO_NO,
    T18.mobileNumber AS APP_MOBILE_NO,
    T18.mobileCountryCode AS APP_MOBILE_CODE,
    CONVERT( FROM_BASE64(T17.passwordBase64) USING UTF8) AS APP_PASSWORD,
    T5.programNameToBePrint AS APP_PROGRAM_NAME,
    T4.printName AS APP_INTAKE_NAME,
    T6.printName AS APP_PERIOD_NAME,
    T17.code AS APP_STUDENT_ID,
    T15.itemValue AS APP_ACADEMIC_TERM,
    T16.itemValue AS APP_INTAKE_YEAR,
    T20.itemValue AS APP_MODE_OF_DELIVERY,
	 if(T4.batchPartTime = TRUE, 'Part Time', 'Full Time') AS APP_REGISTRATION_TYPE,
    T4.startDate AS APP_INTAKE_START_DATE,
    T4.tillDate AS APP_INTAKE_END_DATE,
    T7.academyName AS APP_ACADEMY_NAME,
    T7.locationName AS APP_LOCATION_NAME,
    T7.displayName AS APP_ACADEMY_LOCATION,
    T14.seatName AS APP_SEAT_TYPE,
    T9.phoneCountryCode AS APP_PHONE_COUNTRY_CODE,
    T9.phoneAreaCode AS APP_PHONE_AREA_CODE,
    T9.phoneNo AS APP_PHONE_NO,
    T9.primaryeEmailId AS APP_CAMPUS_EMAILID,
    addr.websiteURL AS APP_CAMPUS_WEBSITE_URL,
    stdaddr.addressText AS APP_STD_ADDRESS,
    T18.nationalID as APP_NATIONAL_ID,
    T22.idTypeName as APP_ID_TYPE,
    T21.salutationName AS APP_TITLE,
    T39.itemValue AS APP_CAST_CATEGORY,
    T23.itemValue AS APP_NATIONALITY,
    T26.value AS APP_HOME_LANGUAGE,
    T2.admissionDate AS APP_ADMISSION_DATE,
	T29.addressText AS APP_CURRENT_ADDRESS,
    T36.countryName AS APP_COUNTRY_NAME_STUDENT,
    T37.countryRegionName AS APP_COUNTRY_REGION_STUDENT,
    T38.cityName AS APP_CITY_STUDENT,
    T29.pincode AS APP_POSTAL_CODE,
	pt.name AS APP_PAYMENT_TERM,
 T1.requestReceivedDate AS APP_REQUEST_RECEIVED_DATE,
    (select itemValue from student_course_enrollment scen join exam_center_csm eccsm on eccsm.id=scen.examCenterId where scen.examCenterId is not null and scen.admissionId=T2.id and scen.programBatchPeriodConfigId=T6.id order by scen.examCenterId desc limit 1 ) AS APP_EXAM_CENTER
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T5.academyLocationId
		LEFT OUTER JOIN
	academy_location_addresses ala on ala.academyLocationId = T7.id
		LEFT OUTER JOIN
    address addr ON addr.id = ala.addressId 
        LEFT OUTER JOIN
    locations T19 ON T19.id = T7.locationId
        LEFT OUTER JOIN
    location_addresses T8 ON T8.locationId = T19.id
        LEFT JOIN
    address T9 ON T9.id = T8.addressId
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 ON T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 ON T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 ON T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 ON T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 ON T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 ON T18.id = T3.personId
   LEFT OUTER JOIN gender g ON g.id = T18.genderId
        LEFT OUTER JOIN
    person_addresses pa ON T18.id = pa.personId
		AND pa.whetherPrimary = TRUE
        LEFT OUTER JOIN
    address stdaddr ON pa.addressId = stdaddr.id
        LEFT JOIN
    mode_of_delivery T20 ON T20.id = T4.modeOfDeliveryId
       LEFT OUTER JOIN 
    caste_categories T39 on T39.id = T18.castCategoryId
       LEFT OUTER JOIN 
	salutations T21 ON T21.id = T18.salutationId
       Left outer join 
    id_type T22 on T22.id= T18.idTypeId
         Left outer join 
    nationalities T23 on T23.id = T18.nationalityId
		 Left outer join 
    drop_down T26 on T26.id = T18.homeLanguage
         LEFT OUTER JOIN 
    person_addresses T27 on T27.personId = T18.id
         LEFT OUTER JOIN 
    address_type T28 on T28.id = T27.addressTypeId and T28.code = 'CRNT' and T28.addressCategory = 'PERSON'
         LEFT OUTER JOIN 
    address T29 on T29.id = T27.addressId
		 LEFT OUTER JOIN
    city T38 ON T38.id = T29.cityId
         LEFT OUTER JOIN
    country_region T37 ON T37.id = T38.countryRegionId
        LEFT OUTER JOIN
    country T36 ON T36.id = T37.countryId
   left outer join payment_term pt on pt.id = T1.paymentTermId"
    where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO';
END IF; 
IF EXISTS ((SELECT id FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO' limit 1)) THEN
SET @dydtdatalinitemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO' limit 1);
IF NOT EXISTS ((select * from dydt_templateparams_translations where translationCode='APP_REQUEST_RECEIVED_DATE')) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('APP_REQUEST_RECEIVED_DATE', 'Request Received Date', @dydtdatalinitemId);
END IF;
IF NOT EXISTS ((select * from dydt_templateparams_translations where translationCode='APP_EXAM_CENTER')) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES ('APP_EXAM_CENTER', 'Exam Center', @dydtdatalinitemId);
END IF;
END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240104122606__Update_UpdateRegistrationConfirmationLater () $$
DROP PROCEDURE IF EXISTS V20240104122606__Update_UpdateRegistrationConfirmationLater $$
DELIMITER ;