DELIMITER $$
DROP PROCEDURE IF EXISTS V20240109190704__Create_StudentResultReport_CSM $$
CREATE PROCEDURE V20240109190704__Create_StudentResultReport_CSM()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_result_report') THEN

CREATE TABLE IF NOT EXISTS `student_result_report` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`columnCode` VARCHAR(255) NOT NULL,
		`isVisible` BIT,
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);  
    
INSERT INTO standard_master(`id`, `tableName`, `masterName`,`moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'student_result_report', 'student_result_report','Examinations','COMMON_MASTER', 0, 0, '1', NOW());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
 VALUES (@ItemsMaxId + 1, 'columnCode', 'COLUMN_NAME', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 1, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,maxLength, `lastUpdatedBy`, `lastUpdate`)
 VALUES (@ItemsMaxId + 1, 'isVisible', 'Visibility', @standardMasterMaxId + 1, 'Enum','VISIBLITY', '2', 0, 0, 0, 1,8, '1', NOW());

insert into picklist_enum(enumType, code, enumValue)
values('VISIBLITY','VISIBLE','Visible' ),
('VISIBLITY','HIDE','Hide');

INSERT INTO student_result_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Max Marks/Grade',true,now(),1);
INSERT INTO student_result_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Obtained Marks/ Grades',true,now(),1);
INSERT INTO student_result_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Weightage',true,now(),1);
INSERT INTO student_result_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Effective Marks/ Grades',true,now(),1);
INSERT INTO student_result_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Moderation Marks',true,now(),1);

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='student_result_report')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','student_result_report','Student Result Report','Student Result Report','Studente resultateverslag','Báo cáo kết quả học sinh',now(),1);     
 
END IF;
END IF; 
END $$
CALL V20240109190704__Create_StudentResultReport_CSM () $$ 
DROP PROCEDURE IF EXISTS V20240109190704__Create_StudentResultReport_CSM $$ 
DELIMITER ;