DELIMITER $$
DROP PROCEDURE IF EXISTS V20240228142051__ClearAcademiaJobLogEvent $$
CREATE PROCEDURE V20240228142051__ClearAcademiaJobLogEvent()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='academia_job_detail_logs' AND column_name='report')) THEN 

ALTER TABLE `academia_job_detail_logs` 
ADD COLUMN `report` TEXT NULL DEFAULT NULL AFTER `triggeredBy`;

END IF;
END $$
CALL V20240228142051__ClearAcademiaJobLogEvent() $$
DROP PROCEDURE IF EXISTS V20240228142051__ClearAcademiaJobLogEvent $$
DELIMITER ;


DELIMITER $$

DROP EVENT IF EXISTS delete_old_academia_job_logs$$

CREATE EVENT delete_old_academia_job_logs
ON SCHEDULE EVERY 1 DAY
STARTS TIMESTAMP(CURRENT_DATE, '00:05:00') + INTERVAL 1 DAY
DO
BEGIN
	insert into hard_delete_files(filePath, fileName, moduleName, lastUpdatedBy)
		SELECT 
	    	SUBSTRING(log.report, 1, LENGTH(log.report) - LENGTH(SUBSTRING_INDEX(log.report, '/', -1)) - 1) AS filePath,
	    	SUBSTRING_INDEX(log.report, '/', -1) AS fileName,
	    	'JOB_REPORT' as moduleName,
	    	case when log.triggeredBy is null then 1 else log.triggeredBy end as lastUpdatedBy
		from academia_job_detail_logs as log where log.report is not null;
	DELETE FROM academia_job_detail_logs
  WHERE startTime < NOW() - INTERVAL 90 DAY;
END$$

DELIMITER ;
