DELIMITER $$
DROP PROCEDURE IF EXISTS V20240229144035__Update_dydtDataLineItemProvider $$
CREATE PROCEDURE V20240229144035__Update_dydtDataLineItemProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select MAX(id) from dydt_data_line_item where dataSourceCode='STUDENT_ADMISSION_PROGRAM_INFO')) THEN 
set @dydtDataLineItemId =(select dataProviderId from dydt_data_line_item where dataSourceCode='STUDENT_ADMISSION_PROGRAM_INFO');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = "SELECT 
    p.programCode AS program_code,
    p.programName AS program_name,
    p.programNameToBePrint AS program_print_name,
    pd.shortCode AS primary_dept_code,
    pd.deptName AS primary_dept_name,
    psd.shortCode AS secondary_dept_code,
    psd.deptName AS secondary_dept_name,
    b.batchName AS batch_name,
    b.printName AS batch_printName,
    sal.salutationName AS student_salutation,
    DATE_FORMAT(DATE(b.startDate), '%d-%m-%Y') AS batch_start_date,
    DATE_FORMAT(DATE(b.tillDate), '%d-%m-%Y') AS batch_tilldate,
    ay.itemValue AS intake_year,
    a.code AS admission_code,
    a.studentId AS student_id,
    pbpc.programPeriodName AS period_name,
    pbpc.printName AS period_print_name,
    prsn.photoUrl AS img_photo_url,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS today_date,
    u.code AS person_code,
    prsn.firstName AS first_name,
    prsn.middleName AS middle_name,
    prsn.lastName AS last_name,
    (CASE
        WHEN (prsn.genderId = 1) THEN 'Male'
        WHEN (prsn.genderId = 2) THEN 'Female'
        WHEN (prsn.genderId = 3) THEN 'Transgender'
        ELSE NULL
    END) AS student_gender,
    cc.itemValue AS cast_category,
    DATE_FORMAT(DATE(prsn.birthDate), '%d-%m-%Y') AS birth_date,
    ntn.itemValue AS nationality,
    rel.itemValue AS religions,
    sec.sectionCode AS section_code,
    DATE_FORMAT(a.admissionDate, '%d-%m-%Y') AS admission_date,
    TRUNCATE(DATEDIFF(DATE_FORMAT(DATE(NOW()), '%Y-%m-%d'),
                prsn.birthDate) / 365.25,
        0) AS student_age,
    (CASE
        WHEN (prsn.bloodGroup = 'O_PLUS') THEN 'O+'
        WHEN (prsn.bloodGroup = 'O_MINUS') THEN 'O-'
        WHEN (prsn.bloodGroup = 'A_PLUS') THEN 'A+'
        WHEN (prsn.bloodGroup = 'A_MINUS') THEN 'A-'
        WHEN (prsn.bloodGroup = 'B_PLUS') THEN 'B+'
        WHEN (prsn.bloodGroup = 'B_MINUS') THEN 'B-'
        WHEN (prsn.bloodGroup = 'AB_PLUS') THEN 'AB+'
        WHEN (prsn.bloodGroup = 'AB_MINUS') THEN 'AB-'
        ELSE NULL
    END) AS blood_group,
    affUniv.itemValue AS affiliated_University,
    affUniv.itemValueOtherLanguage AS affiliated_University_other_language,
    prsn.birth_place AS birth_place,
    prsn.birth_place_language AS birth_place_other_language,
    prsn.printNameOtherLanguage AS print_Name_Other_Language,
    p.programNameLanguageOne AS program_Name_Language_One,
    md.itemValue AS mode_of_delievery,
    md.itemValueOtherLanguage AS mode_of_delievery_other_language,
    dcr.recommendation AS recommendation,
    pg.groupName AS program_group,
    co.effectiveDate AS effective_pass_out_date,
    po.decisionNumber AS decision_number,
    dd.value AS home_language,
    prsn.nationalID AS national_id,
    prsn.category AS Category,
    heqf.itemValue AS NQF_LEVEL,
    p.saqaId AS SAQA_ID,
    REPLACE(b.minProgramCredits, '.0', '') AS NUMBER_OF_CREDITS,
    DATE_FORMAT(DATE(pbpc.programPeriodEnd), '%d %M %Y') AS PERIOD_END_DATE,
    al.displayName AS ACADEMY_LOCATION_DISPLAY_NAME_ADM,
    ad.phoneCountryCode AS AL_PHONE_COUNTRY_CODE_ADM,
    ad.phoneNo AS AL_PHONE_NO_ADM,
    ad.cellCountryCode AS ACADEMY_LOC_CELL_COUNTRY_CODE_ADM,
    ad.cellNo AS ACADEMY_LOC_CELL_NO_ADM,
    addr.addressText AS ADDRESSTEXT_ADM,
    city.cityName AS ADDRESSTEXTCITYNAME_ADM,
    addr.pincode AS ADDRESSTEXTPINCODE_ADM,
    country.countryName AS ADDRESSTEXTCOUNTRYNAME_ADM,
    ad.primaryeEmailId AS ACADEMY_LOC_PRIMARY_EMAIL_ID_ADM,
    prsn.mobileCountryCode AS MOBILECODE_STU,
    prsn.mobileNumber AS MOBILE_NUMBER_STU,
    prsn.emailId AS EMAIL_ID,
    prsn.alternateEmailId AS ALTERNATE_EMAIL_ID,
    u.printName AS STUDENT_PRINT_NAME,
	prsn.mobileNumber AS MOBILE_NO,
    (CASE
        WHEN
            al.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', al.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            al.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', al.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
  c.certificateName as LETTER_NAME
FROM
    program_batch_students pbs
        LEFT JOIN
    admission a ON a.id = pbs.admissionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON b.programId = p.id
        LEFT JOIN
    intake_year ay ON ay.id = b.intakeYearId
        LEFT JOIN
    department pd ON pd.id = p.programDepartmentId
        LEFT JOIN
    department psd ON psd.id = p.subDepartmentId
        LEFT JOIN
    prog_batch_period_config pbpc ON pbpc.programBatchId = b.id
        LEFT JOIN
    students st ON st.userId = a.studentId
        LEFT JOIN
    persons prsn ON prsn.id = st.personId
        LEFT JOIN
    users u ON u.id = st.userId
        LEFT JOIN
    caste_categories cc ON cc.id = prsn.castCategoryId
        LEFT JOIN
    nationalities ntn ON ntn.id = prsn.nationalityId
        LEFT JOIN
    religions rel ON rel.id = prsn.religionId
        LEFT JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    salutations sal ON sal.id = prsn.salutationId
        LEFT JOIN
    affiliated_university affUniv ON affUniv.id = p.affiliatedUniversityId
        LEFT JOIN
    mode_of_delivery md ON md.id = p.modeOfDeliveryId
        LEFT JOIN
    degree_classification_batch_mapping dcbm ON dcbm.batchId = b.id
        LEFT JOIN
    degree_classification_remark dcr ON dcr.degreeClassificationId = dcbm.degreeClassificationId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    completions co ON co.admissionId = a.id
        AND co.batchId = pbs.programBatchId
        LEFT JOIN
    passing_outs po ON po.completionId = co.id
        LEFT JOIN
    drop_down dd ON dd.id = prsn.homeLanguage
    LEFT JOIN
    heqf_level heqf ON p.heqfLevelId = heqf.id
        INNER JOIN
    academy_location al ON a.academyLocationId = al.id
        LEFT JOIN
    location_addresses la ON al.locationId = la.locationId
        LEFT JOIN
    address ad ON la.addressId = ad.id
        AND ad.addressTypeId = 3
        LEFT OUTER JOIN
    persons per ON st.personId = per.id
        LEFT OUTER JOIN
    person_addresses pa ON per.id = pa.personId
        AND pa.whetherPrimary = TRUE
        LEFT OUTER JOIN
    address addr ON pa.addressId = addr.id
        LEFT OUTER JOIN
    city city ON city.id = addr.cityId
        LEFT OUTER JOIN
    country country ON country.id = city.countryId
        LEFT OUTER JOIN
    `organizations` org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations) 
    LEFT JOIN student_documents stdoc on (stdoc.studentId = a.studentId and stdoc.certificateId is not null )
	LEFT JOIN certificates c on c.id = stdoc.certificateId",
    
    `resultColumnsDef` = 'program_code,program_name,program_print_name,batch_printName,student_salutation, primary_dept_code,cast_category,birth_date,\nprimary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,intake_year,section_code,\nadmission_code,student_id,last_name,first_name,middle_name,person_code,img_photo_url,period_name,period_print_name,nationality,religions,\ntoday_date,student_age,student_gender,blood_group,admission_date,affiliated_University,affiliated_University_other_language,birth_place,\nbirth_place_other_language,print_Name_Other_Language,program_Name_Language_One,mode_of_delievery,mode_of_delievery_other_language,recommendation,program_group,effective_pass_out_date,decision_number,home_language,national_id,Category,NQF_LEVEL,SAQA_ID,NUMBER_OF_CREDITS,PERIOD_END_DATE,ACADEMY_LOCATION_DISPLAY_NAME_ADM,AL_PHONE_COUNTRY_CODE_ADM,AL_PHONE_NO_ADM,ACADEMY_LOC_CELL_COUNTRY_CODE_ADM,ACADEMY_LOC_CELL_NO_ADM,ADDRESSTEXT_ADM,ADDRESSTEXTCITYNAME_ADM,ADDRESSTEXTPINCODE_ADM,ADDRESSTEXTCOUNTRYNAME_ADM,ACADEMY_LOC_PRIMARY_EMAIL_ID_ADM,MOBILECODE_STU,MOBILE_NUMBER_STU,EMAIL_ID,ALTERNATE_EMAIL_ID,STUDENT_PRINT_NAME,MOBILE_NO,HEADER_URL,FOOTER_URL,LETTER_NAME'
WHERE
    `dataSourceCode` = 'STUDENT_ADMISSION_PROGRAM_INFO' AND dataProviderId = @dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240229144035__Update_dydtDataLineItemProvider () $$
DROP PROCEDURE IF EXISTS V20240229144035__Update_dydtDataLineItemProvider $$
DELIMITER ;