DELIMITER $$
DROP PROCEDURE IF EXISTS V20240229150356__Create_EmpWorkAnniversaryEvent $$
CREATE PROCEDURE V20240229150356__Create_EmpWorkAnniversaryEvent()
BEGIN

IF NOT EXISTS (((SELECT * FROM msg_category WHERE `code`='EMPLOYEES_WORK_ANNIVERSARY'))) THEN 

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='GENERAL');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EMPLOYEES_WORK_ANNIVERSARY'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EMPLOYEES_WORK_ANNIVERSARY');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'MSG_EMPLOYEES_WORK_ANNIVERSARY', 'Msg Employees Work Anniversary', 'SYSTEM_SCHEDULE', 0, 0, 1, 0, 1, 0, 0, 'MSG_EMPLOYEES_WORK_ANNIVERSARY');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'MSG_EMPLOYEES_WORK_ANNIVERSARY_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'MSG_EMPLOYEES_WORK_ANNIVERSARY_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_EMPLOYEES_WORK_ANNIVERSARY_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'MSG_EMPLOYEES_WORK_ANNIVERSARY_RECIPIENT');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_EMPLOYEES_WORK_ANNIVERSARY_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='MSG_EMPLOYEES_WORK_ANNIVERSARY_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_EMPLOYEES_WORK_ANNIVERSARY_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT s.userId AS USER_ID FROM staffs s WHERE DATE_FORMAT(s.joiningDate, '%m-%d') = DATE_FORMAT(NOW(), '%m-%d') and s.exitDate is null ",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_EMPLOYEES_WORK_ANNIVERSARY_RCPNT');


INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT ID, JOININ_DATE, SALUTATION_NAME, FIRST_NAME, MIDDLE_NAME, LAST_NAME, EMAIL_ID, MOBILE_NO, MOBILE_CODE, GROUP_CONCAT(DEVICE_ID) AS DEVICE_ID, LOGO_URL, ACADEMY_LOCATION_ID, ACADEMY_ID, LOCATION_ID FROM (SELECT s.userId AS ID, s.joiningDate AS JOININ_DATE, sal.salutationName AS SALUTATION_NAME, p.firstName AS FIRST_NAME, p.middleName AS MIDDLE_NAME, p.lastName AS LAST_NAME, p.emailId AS EMAIL_ID, p.mobileNumber AS MOBILE_NO, p.mobileCountryCode AS MOBILE_CODE, (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png' ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL, f.deviceTokenId AS DEVICE_ID, al.id AS ACADEMY_LOCATION_ID, al.academyId AS ACADEMY_ID, al.locationId AS LOCATION_ID FROM staffs s INNER JOIN users u ON u.id = s.userId INNER JOIN persons p ON p.id = s.personId LEFT JOIN salutations sal ON sal.id = p.salutationId LEFT JOIN fire_base_persons_info f ON f.userId = u.id LEFT JOIN user_academy_locations ual ON ual.userId = u.id AND ual.whetherPrimary = TRUE LEFT JOIN academy_location al ON al.id = ual.academyLocationId LEFT JOIN organizations org ON org.id = 1) AS PSEUDO WHERE DATE_FORMAT(JOININ_DATE, '%m-%d') = DATE_FORMAT(NOW(), '%m-%d') AND id IN (namedParams) GROUP BY id",'{\r\n    \"id\": 1,\r\n    \"searchResultViewColumns\": [\r\n        {\r\n            \"id\": 1,\r\n            \"value\": \"id\",\r\n            \"resultKey\": \"ID\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 0\r\n        },\r\n        {\r\n            \"id\": 2,\r\n            \"value\": \"salutationName\",\r\n            \"resultKey\": \"SALUTATION_NAME\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 1\r\n        },\r\n        {\r\n            \"id\": 3,\r\n            \"value\": \"firstName\",\r\n            \"resultKey\": \"FIRST_NAME\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 2\r\n        },\r\n        {\r\n            \"id\": 4,\r\n            \"value\": \"middleName\",\r\n            \"resultKey\": \"MIDDLE_NAME\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 3\r\n        },\r\n        {\r\n            \"id\": 5,\r\n            \"value\": \"lastName\",\r\n            \"resultKey\": \"LAST_NAME\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 4\r\n        },\r\n        {\r\n            \"id\": 6,\r\n            \"value\": \"emailId\",\r\n            \"resultKey\": \"EMAIL_ID\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 5\r\n        },\r\n        {\r\n            \"id\": 7,\r\n            \"value\": \"mobileNumber\",\r\n            \"resultKey\": \"MOBILE_NO\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 6\r\n        }\r\n    ]\r\n}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='MSG_EMPLOYEES_WORK_ANNIVERSARY_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='MSG_EMPLOYEES_WORK_ANNIVERSARY');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EMPLOYEES_WORK_ANNIVERSARY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='MSG_EMPLOYEES_WORK_ANNIVERSARY_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'MSG_EMPLOYEES_WORK_ANNIVERSARY_TEMPLATE',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,1,NULL,NULL,'MSG_EMPLOYEES_WORK_ANNIVERSARY_TEMPLATE',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Employees Work Anniversary','<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px; border-collapse:collapse\">\n       <tr>\n       	<td align=\"center\" style=\"background-color: #727272; color: #f4f4f4; margin:0px; padding:4px;\">\n       		<h3 style=\"margin-top:20px;\">Happy Work Anniversary </h3>\n       	</td>\n       </tr>  \n      <tr>\n      	<td  align=\"center\" style=\"background-color: #727272; margin:0px; padding:4px;\"><img style=\"margin-bottom:20px;\" src=\"http://www.serosoft.in/mailer/academia_email.png\" >\n      	</td>\n      </tr>\n      </table>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Employees Work Anniversary','<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px; border-collapse:collapse\">\n       <tr>\n       	<td align=\"center\" style=\"background-color: #727272; color: #f4f4f4; margin:0px; padding:4px;\">\n       		<h3 style=\"margin-top:20px;\">Happy Work Anniversary </h3>\n       	</td>\n       </tr>  \n      <tr>\n      	<td  align=\"center\" style=\"background-color: #727272; margin:0px; padding:4px;\"><img style=\"margin-bottom:20px;\" src=\"http://www.serosoft.in/mailer/academia_email.png\" >\n      	</td>\n      </tr>\n      </table>');

END IF; 

END $$
CALL V20240229150356__Create_EmpWorkAnniversaryEvent () $$ 
DROP PROCEDURE IF EXISTS V20240229150356__Create_EmpWorkAnniversaryEvent $$ 
DELIMITER ;