DELIMITER $$
DROP PROCEDURE IF EXISTS V20240320190302__Insert_MAKINI_REPORT_CARD_EARLY_YEARS $$
CREATE PROCEDURE V20240320190302__Insert_MAKINI_REPORT_CARD_EARLY_YEARS()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS (select * from report_template where templateCode='MAKINI_REPORT_CARD_EARLY_YEARS') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'MAKINI_REPORT_CARD_EARLY_YEARS', 'Makini-Academic Report card Early Years', 'MAKINI_REPORT_CARD_EARLY_YEARS.png', 'MAKINI_REPORT_CARD_EARLY_YEARS_CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'MAKINI_REPORT_CARD_EARLY_YEARS.jasper', 'AcademiaLogo.png');
END IF;

set @tempId = (select max(id) from report_template where templateCode='MAKINI_REPORT_CARD_EARLY_YEARS' and templateName='Makini-Academic Report card Early Years');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PERSONAL_LEARNING_JOURNEY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PERSONAL_LEARNING_JOURNEY', 'PERSONAL LEARNING JOURNEY', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NAME', "Learner's name", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_LEARNER_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LEARNER_NO', "Learner's number", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DOB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DOB', 'Date of birth', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TEACHER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TEACHER', 'Teacher', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DAYS_ABSENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DAYS_ABSENT', 'Days Absent', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_LEARNER_SD_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LEARNER_SD_NO', "Learner’s SD Number", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_EARLY_YEARS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_EARLY_YEARS', 'EARLY YEARS -', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TEACHER_SIGN') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TEACHER_SIGN', 'Teacher signature', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PRINCIPAL_SIGN') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PRINCIPAL_SIGN', "Principal's signature", '1', now());
END IF;

END $$
CALL V20240320190302__Insert_MAKINI_REPORT_CARD_EARLY_YEARS() $$
DROP PROCEDURE IF EXISTS V20240320190302__Insert_MAKINI_REPORT_CARD_EARLY_YEARS $$
DELIMITER ;