DELIMITER $$
DROP PROCEDURE IF EXISTS V20240321161843__Create_blackboardDeenrollment $$
CREATE PROCEDURE V20240321161843__Create_blackboardDeenrollment()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='blackboard_deenrollment')) THEN 
drop view blackboard_deenrollment;
END IF; 
create view blackboard_deenrollment as select map.id, 'studnet' as courseRoleId, map.blackboardCourseId, map.blackboardUserId 
from blackboard_user_course_membership_mapping map 
join  users u on map.academiaUserId = u.id and map.courseRoleId='Student'
join admission a on a.studentId = u.id and a.activeStatus=true
join student_course_enrollment enrol on  enrol.courseVarientId=map.academiaCourseVariantId 
and enrol.admissionId = a.id and enrol.exitDate is not null
union all
select  map.id, 'studnet' as courseRoleId,map.blackboardCourseId, map.blackboardUserId 
from blackboard_user_course_membership_mapping map
join  users u on map.academiaUserId = u.id and map.courseRoleId='Student'
join admission a on a.studentId = u.id and a.activeStatus=true
left join student_course_enrollment enrol on  enrol.courseVarientId=map.academiaCourseVariantId 
and enrol.admissionId = a.id
where enrol.id is null
union all 
select  map.id, 'Instructor' as courseRoleId,map.blackboardCourseId, map.blackboardUserId  
FROM blackboard_user_course_membership_mapping map
left JOIN (
    SELECT t2.*
    FROM program_batch_course_param t2
    INNER JOIN prog_batch_course_faculty t3 ON t2.id = t3.progBatchCourseParamId
) filtered_t2 ON map.academiaCourseVariantId = filtered_t2.courseVarientId
LEFT JOIN prog_batch_course_faculty t3 ON filtered_t2.id = t3.progBatchCourseParamId AND t3.facultyId = map.academiaUserId
WHERE t3.facultyId IS NULL
AND map.courseRoleId = 'Instructor';
END $$ 
CALL V20240321161843__Create_blackboardDeenrollment () $$ 
DROP PROCEDURE IF EXISTS V20240321161843__Create_blackboardDeenrollment $$ 
DELIMITER ;