DELIMITER $$
DROP PROCEDURE IF EXISTS V20240321185908__Create_dtef_app_prog_mapping $$
CREATE PROCEDURE V20240321185908__Create_dtef_app_prog_mapping()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='dtef_app_prog_mapping'))) THEN 
CREATE TABLE `dtef_app_prog_mapping` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`applicationProgramId` BIGINT(20) NOT NULL,
  		`response` varchar(255) NULL,
        `responseStatus` varchar(255) NULL,
        `responseDate` date NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_dtef_app_prog_mapping_id_idx` (`applicationProgramId` ASC),
		INDEX `fk_dtef_app_prog_mapping_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_dtef_app_prog_mapping_id_idx`
		    FOREIGN KEY (`applicationProgramId`)
		    REFERENCES `application_program` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_dtef_app_prog_mapping_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20240321185908__Create_dtef_app_prog_mapping () $$ 
DROP PROCEDURE IF EXISTS V20240321185908__Create_dtef_app_prog_mapping $$ 
DELIMITER ;