DELIMITER $$
DROP PROCEDURE IF EXISTS V20240326191303__Insert_NationalIDExpiryEvent $$
CREATE PROCEDURE V20240326191303__Insert_NationalIDExpiryEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='STUDENT_NATIONAL_ID_EXPIRY')) THEN 
-- =======================Messaging event: Event Reminder Schedule=============================================
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'STUDENT_NATIONAL_ID_EXPIRY'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT_NATIONAL_ID_EXPIRY');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'NATIONAL_ID_EXPIRY_REMINDER', 'National ID Expiry Reminder', 'SYSTEM_SCHEDULE', 0, 0, 1, 0, 1, 0, 0, 'National ID Expiry Reminder');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NATIONAL_ID_EXPIRY_REMINDER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NATIONAL_ID_EXPIRY_REMINDER_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NATIONAL_ID_EXPIRY_REMINDER_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'NATIONAL_ID_EXPIRY_REMINDER_RCPNT');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NATIONAL_ID_EXPIRY_REMINDER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NATIONAL_ID_EXPIRY_REMINDER_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NATIONAL_ID_EXPIRY_REMINDER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    ps.id AS USER_ID
FROM
persons ps cross join 
    drop_down d 
WHERE
    (ps.identityExpiryDate = (DATE_FORMAT(DATE(NOW())  + interval d.value day , '%Y-%m-%d')))
    AND d.type='NationalIdExpiryDays'",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NATIONAL_ID_EXPIRY_REMINDER_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
	ps.id AS ID,
    T33.countryName AS Student_Address_countryName,
    T34.countryRegionName AS Student_Address_countryRegionName,
    T32.cityName AS Student_Address_cityName,
    T31.postalCode AS Student_Address_postalCode,
    T31.phoneNo AS Student_Address_phoneNo,
    T31.cellNo AS Student_Address_cellNo,
    T31.primaryeEmailId AS Student_Address_primaryeEmailId,
    T21.orgName AS ORGANIZATION_NAME,
    T25.countryName AS Organization_countryName,
    T26.countryRegionName AS Organization_countryRegionName,
    T24.cityName AS Organization_cityName,
    T23.postalCode AS Organization_postalCode,
    T23.phoneNo AS Organization_phoneNo,
    T23.cellNo AS Organization_cellNo,
    T23.primaryeEmailId AS Organization_primaryeEmailId,
    T17.displayName AS Academic_location,
    T3.code AS STUDENT_ID,
    T28.printName AS PERIOD_NAME,
    ps.mobileNumber AS MOBILE_NO,
    ps.emailId AS EMAIL_ID,
    ps.alternateEmailId AS SECONDARY_EMAIL_ID,
    ps.printName AS STUDENT_NAME,
    ps.firstName AS FIRST_NAME,
    ps.middleName AS MIDDLE_NAME,
    ps.lastName AS LAST_NAME,
    T5.programNameToBePrint AS Programme_Name,
    T4.code AS ADMISSION_ID,
	T29.printName AS BATCH_NAME,
    ps.nationalID AS National_ID,
    ps.identityExpiryDate AS National_ID_Expiry_Date,
    T35.idTypeName AS ID_Type,
    (CASE
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(T21.orgUrl, '/', T17.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T17.headerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T17.footerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.id) AS DEVICE_ID
FROM
    persons  ps
        LEFT JOIN
    students T2 ON T2.personId = ps.id
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    admission T4 ON T4.studentId = T3.id
        LEFT JOIN
    programs T5 ON T5.id = T4.programId
        LEFT JOIN
    academy_location T17 ON T17.id = T4.academyLocationId
        LEFT JOIN
    academies T18 ON T18.id = T17.academyId
        LEFT JOIN
    locations T19 ON T19.id = T17.locationId
         LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    organization_addresses T22 ON T22.organizationId = T21.id
        LEFT JOIN
    address T23 ON T23.id = T22.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId
        LEFT JOIN
    program_batch_students T27 ON T27.admissionId = T4.id
        AND T27.isCurrentPeriod = TRUE
        AND T27.isCurrentSection = TRUE
        AND T27.isPeriodCompleted = FALSE
        AND T27.exitDate IS NULL
        LEFT JOIN
    prog_batch_period_config T28 ON T28.id = T27.progBatchPeriodConfigId
    LEFT JOIN
    batches T29 ON T29.id = T28.programBatchId
    LEFT JOIN
     person_addresses T30 ON T30.personId = ps.id and T30.addressTypeId=5
        LEFT JOIN
    address T31 ON T31.id = T30.addressId 
        LEFT JOIN
    city T32 ON T32.id = T31.cityId
        LEFT JOIN
    country T33 ON T33.id = T32.countryId
        LEFT JOIN
    country_region T34 ON T34.id = T32.countryRegionId
    		LEFT JOIN
    		id_type T35   ON   T35.id = ps.idTypeId
       WHERE
    ps.id in (namedParams)  AND T23.addressTypeId = (SELECT 
            id
        FROM
            address_type oat
        WHERE
            oat.code = 'REG'
                AND oat.addressCategory = 'ORG') ",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "orgName",
            "resultKey": "ORGANIZATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
	 {
            "id": 3,
            "value": "countryName",
            "resultKey": "Organization_countryName",
            "displayCode": "",
            "displayOrder": 2
        },
	 {
            "id": 4,
            "value": "countryRegionName",
            "resultKey": "Organization_countryRegionName",
            "displayCode": "",
            "displayOrder": 3
        },
	 {
            "id": 5,
            "value": "cityName",
            "resultKey": "Organization_cityName",
            "displayCode": "",
            "displayOrder": 4
        },
	 {
            "id": 6,
            "value": "postalCode",
            "resultKey": "Organization_postalCode",
            "displayCode": "",
            "displayOrder": 5
        },
	 {
            "id": 7,
            "value": "phoneNo",
            "resultKey": "Organization_phoneNo",
            "displayCode": "",
            "displayOrder": 6
        },
	 {
            "id": 8,
            "value": "cellNo",
            "resultKey": "Organization_cellNo",
            "displayCode": "",
            "displayOrder": 7
        },
	 {
            "id": 9,
            "value": "primaryeEmailId",
            "resultKey": "Organization_primaryeEmailId",
            "displayCode": "",
            "displayOrder": 8
        },
	 {
            "id": 10,
            "value": "displayName",
            "resultKey": "Academic_location",
            "displayCode": "",
            "displayOrder": 9
        },
	 {
            "id": 11,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "alternateEmailId",
            "resultKey": "SECONDARY_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "programNameToBePrint",
            "resultKey": "Programme_Name",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 20
        },
        {
            "id": 22,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 21
        },
        {
            "id": 23,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 22
        },
        {
            "id": 24,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 23
        },
	 {
            "id": 25,
            "value": "countryName",
            "resultKey": "Student_Address_countryName",
            "displayCode": "",
            "displayOrder": 24
        },
	 {
            "id": 26,
            "value": "countryRegionName",
            "resultKey": "Student_Address_countryRegionName",
            "displayCode": "",
            "displayOrder": 25
        },
	 {
            "id": 27,
            "value": "cityName",
            "resultKey": "Student_Address_cityName",
            "displayCode": "",
            "displayOrder": 26
        },
	 {
            "id": 28,
            "value": "postalCode",
            "resultKey": "Student_Address_postalCode",
            "displayCode": "",
            "displayOrder": 27
        },
	 {
            "id": 29,
            "value": "phoneNo",
            "resultKey": "Student_Address_phoneNo",
            "displayCode": "",
            "displayOrder": 28
        },
	 {
            "id": 30,
            "value": "cellNo",
            "resultKey": "Student_Address_cellNo",
            "displayCode": "",
            "displayOrder": 29
        },
	 {
            "id": 31,
            "value": "primaryeEmailId",
            "resultKey": "Student_Address_primaryeEmailId",
            "displayCode": "",
            "displayOrder": 30
        },
	 {
            "id": 32,
            "value": "printName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 31
        },
	 {
            "id": 33,
            "value": "nationalID",
            "resultKey": "National_ID",
            "displayCode": "",
            "displayOrder": 32
        },
	 {
            "id": 34,
            "value": "identityExpiryDate",
            "resultKey": "National_ID_Expiry_Date",
            "displayCode": "",
            "displayOrder": 33
        },
   	 {
               "id": 35,
               "value": "idTypeName",
               "resultKey": "ID_Type",
               "displayCode": "",
               "displayOrder": 34
           }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='NATIONAL_ID_EXPIRY_REMINDER_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='NATIONAL_ID_EXPIRY_REMINDER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_NATIONAL_ID_EXPIRY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NATIONAL_ID_EXPIRY_REMINDER_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`) 
VALUES(@msgtemplateconfigId+1,'National ID Expiry Reminder',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'National ID Expiry Reminder',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'1','National ID Expiry Reminder','');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'2','NULL','');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'4','National ID Expiry Reminder','');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateconfigId+1,'6','National ID Expiry Reminder','');


END IF; 

END $$
CALL V20240326191303__Insert_NationalIDExpiryEvent() $$
DROP PROCEDURE IF EXISTS V20240326191303__Insert_NationalIDExpiryEvent $$
DELIMITER ;