DELIMITER $$
DROP PROCEDURE IF EXISTS V20240405180251__Alter_moodle_deenrollment $$
CREATE PROCEDURE V20240405180251__Alter_moodle_deenrollment()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='moodle_deenrollment') THEN 
drop view moodle_deenrollment;
END IF;  
create view moodle_deenrollment as select map.id, 5 as moodle_roleid, map.academy_locationid, map.course_variant_moodleid, map.user_moodleid 
from moodle_user_course_mapping map 
join  users u on map.academia_userid = u.id and map.user_type='STUDENT'
join admission a on a.studentId = u.id and a.activeStatus=1 
join student_course_enrollment enrol on  enrol.courseVarientId=map.academia_course_variantid 
and enrol.admissionId = a.id and enrol.exitDate is not null
union
select  map.id, 5 as moodle_roleid, map.academy_locationid, map.course_variant_moodleid, map.user_moodleid 
from moodle_user_course_mapping map
join  users u on map.academia_userid = u.id and map.user_type='STUDENT'
join admission a on a.studentId = u.id and a.activeStatus=1 
left join student_course_enrollment enrol on  enrol.courseVarientId=map.academia_course_variantid 
and enrol.admissionId = a.id
where enrol.id is null
union
select  map.id, 3 as moodle_roleid, map.academy_locationid, map.course_variant_moodleid, map.user_moodleid 
from moodle_user_course_mapping map
left join (select param.id, param.courseVarientId, fac.facultyId
    from program_batch_course_param param
    join prog_batch_course_faculty fac ON param.id = fac.progBatchCourseParamId) allmap 
on map.academia_course_variantid = allmap.courseVarientId 
left join prog_batch_course_faculty faculty on allmap.id = faculty.progBatchCourseParamId and faculty.facultyId = map.academia_userid
where faculty.facultyId is null and map.user_type='FACULTY';

END $$
CALL V20240405180251__Alter_moodle_deenrollment() $$
DROP PROCEDURE IF EXISTS V20240405180251__Alter_moodle_deenrollment $$
DELIMITER ;