DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseStMappingbb $$
CREATE PROCEDURE fatchCourseStMappingbb()
BEGIN
    SELECT 
    func_inc_var_session_rec() AS `Id`,
    usr.id AS 'studentId',
    usr.code AS 'studentCode',
    adm.id AS 'admissionId',
    adm.code AS 'admissionCode',
    pbpc.id AS 'periodId',
    cv.id AS 'courseVariantsId',
    bum.blackboardUserId AS 'blackboardUserId',
    bcm.blackboardCourseId AS 'blackboardCourseId'
    FROM student_course_enrollment scm
    JOIN admission adm ON scm.admissionId = adm.id
    JOIN users usr ON usr.id = adm.studentId
    JOIN prog_batch_period_config pbpc ON scm.programBatchPeriodConfigId = pbpc.id
    JOIN (
        SELECT DISTINCT 
            pbs.admissionId AS ad_id,
            pbs.progBatchPeriodConfigId AS Period_id,
            count(distinct param_cv.id) AS Param_Course_Code_Count,
            count(DISTINCT sce_cv.id) AS Sce_Course_Code_Count,
            count(DISTINCT bh.id) AS Sce_Bill_ID
        FROM 
            program_batch_students pbs 
        JOIN 
            program_batch_course_param param 
            ON pbs.progBatchPeriodConfigId = param.progBatchPeriodConfigId 
        JOIN 
            course_variants param_cv 
            ON param_cv.id = param.courseVarientId
        JOIN 
            courses cours 
            ON param_cv.courseId = cours.id AND cours.isLMSCourses=true
        LEFT JOIN 
            student_course_enrollment sce 
            ON pbs.admissionId = sce.admissionId 
            AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId 
            AND param.courseVarientId = sce.courseVarientId
        LEFT JOIN 
            course_variants sce_cv 
            ON sce.courseVarientId = sce_cv.id
        LEFT JOIN 
            bill_header bh 
            ON sce.billId = bh.id  
            AND bh.billStatus = 'SETTLED'
        WHERE 
            pbs.promotionEnrollmentStatus = 'ENROLLED' 
            AND pbs.exitDate IS NULL  
        GROUP BY 
            pbs.admissionId, 
            pbs.progBatchPeriodConfigId 
        HAVING 
            COUNT(DISTINCT param_cv.id) = COUNT(DISTINCT sce_cv.id) 
            AND COUNT(DISTINCT param_cv.id) = COUNT(DISTINCT bh.id) 
    ) tmp ON scm.admissionId = tmp.ad_id AND scm.programBatchPeriodConfigId = tmp.Period_id
    JOIN course_variants cv ON  scm.courseVarientId = cv.id
    JOIN blackboard_user_mapping bum ON  bum.academiaUserId = usr.id
    JOIN blackboard_course_mapping bcm ON  bcm.academiaCourseVariantId = cv.id 
    LEFT JOIN blackboard_user_course_membership_mapping bucmm ON  bucmm.academiaUserId = usr.id AND bucmm.academiaCourseVariantId = cv.id
    WHERE bucmm.id is null;
END $$ 
DELIMITER ;