DELIMITER $$
DROP PROCEDURE IF EXISTS fatchStudentToBePushInCanvas $$
CREATE PROCEDURE fatchStudentToBePushInCanvas(jobLastRunTimestamp timestamp)
BEGIN
SELECT
    func_inc_var_session_rec() AS id,
    user.id as userId,
    user.code as userCode,
    user.printName as userName,
    user.shortName as shortName,
    stuPer.emailId as email,
    location.id as locationId,
    userMapping.canvasUserId as canvasUserId,
    'STUDENT'   as role
FROM
    users AS user
		JOIN
    students AS stu ON stu.userId = user.id
		left JOIN
	canvas_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		JOIN 
	admission as ad on (ad.studentId=user.id and ad.activeStatus=true)
		JOIN
	academy_location as location on ad.academyLocationId=location.id
        JOIN 
    persons AS stuPer ON stuPer.id = stu.personId
		JOIN 
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        JOIN 
    roles AS role ON role.id = ualr.roleId
    where userMapping.id is null and role.roleName ="STUDENT" and stuPer.emailId is not null
    group by user.id
    UNION ALL SELECT 
    func_inc_var_session_rec() AS id,user.id as userId, user.code as userCode,  user.printName as userName, user.shortName as shortName, stuPer.emailId as email, location.id as locationId,	userMapping.canvasUserId as canvasUserId, 'STUDENT'   as role
FROM
   users AS user
		JOIN
    students AS stu ON stu.userId = user.id
		JOIN
	canvas_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		JOIN 
	admission as ad on (ad.studentId=user.id and ad.activeStatus=true)
		JOIN
	academy_location as location on ad.academyLocationId=location.id
        JOIN 
    persons AS stuPer ON stuPer.id = stu.personId
		JOIN 
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        JOIN 
    roles AS role ON role.id = ualr.roleId
    where role.roleName ="STUDENT" and user.lastUpdate > jobLastRunTimestamp and stuPer.emailId is not null
    group by user.id;
END $$ 
DELIMITER ;