DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseSecToBePushInCanvas $$
CREATE PROCEDURE fatchCourseSecToBePushInCanvas(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    cv.courseVariantCode AS courseVariantCode,
    cv.courseId AS courseId,
    cv.id AS id,
    program.academyLocationId AS locationId,
    canvasCourse.canvasCourseId AS canvasCourseId,
    canvasCourse.id AS canvasCourseMappingId,
    canvasCourseSection.id AS canvasCourseSectionId,
	period.programPeriodStart AS programPeriodStart,
    period.programPeriodEnd AS programPeriodEnd

FROM
    course_variants AS cv 
		join
	program_batch_course_param AS pbcp ON pbcp.courseVarientId=cv.id
		join
	prog_batch_period_config as period ON pbcp.progBatchPeriodConfigId=period.id
		join
	batches as batch ON batch.id =period.programBatchId
		join
	programs as program ON program.id=batch.programId
        inner JOIN
	canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = cv.courseId and canvasCourse.academyLocationId=program.academyLocationId
		left join 
	canvas_course_section_mapping as canvasCourseSection ON canvasCourseSection.academiaCourseVariantId=cv.id
        where canvasCourseSection.id is null  group by program.academyLocationId ,cv.id
UNION ALL SELECT 
    cv.courseVariantCode AS courseVariantCode,
    cv.courseId AS courseId,
    cv.id AS id,
    canvasCourse.academyLocationId AS locationId,
    canvasCourse.canvasCourseId AS canvasCourseId,
    canvasCourse.id AS canvasCourseMappingId,
    canvasCourseSection.id AS canvasCourseSectionId,
	period.programPeriodStart AS programPeriodStart,
    period.programPeriodEnd AS programPeriodEnd
FROM
   course_variants AS cv 
		join
	program_batch_course_param AS pbcp ON pbcp.courseVarientId=cv.id
		join
	prog_batch_period_config as period ON pbcp.progBatchPeriodConfigId=period.id
    	join
	batches as batch ON batch.id =period.programBatchId
		join
	programs as program ON program.id=batch.programId
         JOIN
	canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = cv.courseId and canvasCourse.academyLocationId=program.academyLocationId
		 join 
	canvas_course_section_mapping as canvasCourseSection ON canvasCourseSection.academiaCourseVariantId=cv.id
	WHERE
    cv.lastUpdate > jobLastRunTimestamp
    group by program.academyLocationId ,cv.id;
END $$ 
DELIMITER ;