DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseFcMappingCanvas $$
CREATE PROCEDURE fatchCourseFcMappingCanvas()
BEGIN
  SELECT 
        func_inc_var_session_rec() AS `id`,
        cum.canvasUserId AS 'canvasUserId',
        pbcf.facultyId AS 'facultyId',
        ccsm.canvasCourseSectionId AS 'canvasCourseSectionId',
        cv.id AS 'courseVariantsId',
        cum.academyLocationId AS 'locationId'
    FROM prog_batch_course_faculty pbcf
    JOIN
    user_academy_locations AS ual ON ual.userId = pbcf.facultyId
        JOIN
	academy_location AS location ON location.id=ual.academyLocationId
    JOIN program_batch_course_param pbcp
        ON pbcp.id = pbcf.progBatchCourseParamId
    JOIN course_variants cv
        ON cv.id = pbcp.courseVarientId
    JOIN courses c
        ON c.id = cv.courseId
    JOIN canvas_course_section_mapping ccsm
        ON ccsm.academiaCourseVariantId = cv.id and ual.academyLocationId=ccsm.academyLocationId
    JOIN canvas_user_mapping cum
        ON cum.academiaUserId = pbcf.facultyId and ual.academyLocationId=cum.academyLocationId
    LEFT JOIN canvas_user_course_section_mapping cucsm
        ON cucsm.academiaCourseVariantId = cv.id
        AND cucsm.academiaUserId = pbcf.facultyId
        AND cucsm.academyLocationId= ual.academyLocationId
    WHERE cucsm.id IS NULL;
    
END $$ 
DELIMITER ;