DELIMITER $$
DROP PROCEDURE IF EXISTS V20240711153820__Create_employee_qualification $$
CREATE PROCEDURE V20240711153820__Create_employee_qualification()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_qualification')) THEN 

CREATE TABLE employee_qualification (
id bigint(20) NOT NULL AUTO_INCREMENT,
userId bigint(20) DEFAULT NULL,
qualificationType  bigint(20) DEFAULT NULL,
qualificationCategory bigint(20) DEFAULT NULL,
 qualificationName bigint(20) DEFAULT NULL,
 qualificationMajor1 bigint(20) DEFAULT NULL,
 qualificationMajor2 bigint(20) DEFAULT NULL,
 qualificationMajor3 bigint(20) DEFAULT NULL,
 qualificationHEQFLevel bigint(20) DEFAULT NULL,
 qualificationInstitution bigint(20) DEFAULT NULL,
 qualificationApprovalLevel bigint(20) DEFAULT NULL,
qualificationUsedInApproval bigint(20) DEFAULT NULL,
qualificationStartDate datetime DEFAULT NULL,
qualificationEndDate datetime DEFAULT NULL,
isCompleted BIT NOT NULL DEFAULT b'1',
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),


CONSTRAINT `FK_employee_qualification_FK_userId` FOREIGN KEY (`userId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_employee_qualification_FK_qualificationType` FOREIGN KEY (`qualificationType`) REFERENCES `qualification_type` (`id`),
CONSTRAINT `FK_employee_qualification_FK_qualificationCategory` FOREIGN KEY (`qualificationCategory`) REFERENCES `qualification_category` (`id`), 
 CONSTRAINT `FK_employee_qualification_FK_qualificationName` FOREIGN KEY (`qualificationName`) REFERENCES `qualification_name` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationMajor1` FOREIGN KEY (`qualificationMajor1`) REFERENCES `qualification_major` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationMajor2` FOREIGN KEY (`qualificationMajor2`) REFERENCES `qualification_major` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationMajor3` FOREIGN KEY (`qualificationMajor3`) REFERENCES `qualification_major` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationHEQFLevel` FOREIGN KEY (`qualificationHEQFLevel`) REFERENCES `qualification_heqf_level` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationInstitution` FOREIGN KEY (`qualificationInstitution`) REFERENCES `qualification_institution` (`id`),
 CONSTRAINT `FK_employee_qualification_FK_qualificationApprovalLevel` FOREIGN KEY (`qualificationApprovalLevel`) REFERENCES `qualification_approval_level` (`id`),
CONSTRAINT `FK_employee_qualification_FK_qualificationUsedInApproval` FOREIGN KEY (`qualificationUsedInApproval`) REFERENCES `qualification_used_in_approval` (`id`),
CONSTRAINT `FK_employee_qualification_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF; 
END $$
CALL V20240711153820__Create_employee_qualification () $$ 
DROP PROCEDURE IF EXISTS V20240711153820__Create_employee_qualification $$ 
DELIMITER ;