DELIMITER $$
DROP PROCEDURE IF EXISTS get_sub_type_level_data_for_avg $$
CREATE PROCEDURE get_sub_type_level_data_for_avg(admissionIds text,batchId bigint)
BEGIN
SELECT DISTINCT
    ranks.id AS id,
    ranks.admissionId AS admissionId,
    ranks.courseVariantId AS courseVariantId,
    subType.id AS levelId,
    period.programBatchId AS batchId,
    ranks.effectiveMarks AS effectiveMarks,
    ranks.obtainedMarks AS obtainedMarks,
    subType.evaluationSubType AS levelName
FROM
    evaluation_plan_level_two_rank ranks
        JOIN
    evaluation_plan_level_two levelTwo ON levelTwo.id = ranks.evaluationPlanLevelTwoId
        JOIN
    evaluation_sub_type subType ON subType.id = levelTwo.evaluationSubTypeId
        JOIN
    course_variants cv ON cv.id = ranks.courseVariantId
        JOIN
    prog_batch_period_config period ON period.id = ranks.periodId
WHERE
    (ranks.whetherSpecialGrade IS NULL
        OR ranks.whetherSpecialGrade = FALSE)
        AND (cv.whetherTransferCredits IS NULL
        OR cv.whetherTransferCredits = FALSE)
        AND period.programBatchId = batchId
        AND FIND_IN_SET(ranks.admissionId, admissionIds);
END $$
DELIMITER ;