DELIMITER $$
DROP PROCEDURE IF EXISTS V20240916115145__Update_StatementOfAccountAdhocEvent $$
CREATE PROCEDURE V20240916115145__Update_StatementOfAccountAdhocEvent()
BEGIN

SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT') THEN 

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_ACCOUNT_STATEMENT');

UPDATE sql_dtprovider
set sqlQuery = "
SELECT 
    T1.`id` AS ID,
	T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
	T1.`code` AS STUDENT_CODE,
	DATE_FORMAT(NOW(), '%d-%m-%Y') AS CURRENT_DATE_TODAY,
    T3.`emailId` AS EMAIL_ID,
       (CASE
        WHEN
            (SELECT 
                    emailHome
                FROM
                    fee_payer_detail
                WHERE
                    T2.personId = fee_payer_detail.personId
                        AND fee_payer_detail.isPrimaryFeePayer = 1
                LIMIT 1) IS NOT NULL
        THEN
            (SELECT 
                    emailHome
                FROM
                    fee_payer_detail
                WHERE
                    T2.personId = fee_payer_detail.personId
                        AND fee_payer_detail.isPrimaryFeePayer = 1
                LIMIT 1)
        ELSE (SELECT 
                emailWork
            FROM
                fee_payer_detail
            WHERE
                T2.personId = fee_payer_detail.personId
                    AND payerType = 'CORPORATE'
                    AND fee_payer_detail.isPrimaryFeePayer = 1
            LIMIT 1)
    END) AS ALTERNATE_EMAIL_ID,
	T3.`externalSysRefOne` AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1, 
	T7.`programNameToBePrint` AS PROGRAM,
    T7.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_OTHER_LANGUAGE,
    T6.`printName` AS BATCH,
    T8.`seatName` AS SEAT_TYPE,
    T8.`seatNameOtherLanguage` AS SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE,
	T3.`printNameOtherLanguage` AS STUDENT_PRINT_NAME_OTHER_LANGUAGE,
	T3.`firstNameOtherLanguage` AS STUDENT_FIRST_NAME_OTHER_LANGUAGE,
	T3.`middleNameOtherLanguage` AS STUDENT_MIDDLE_NAME_OTHER_LANGUAGE,
	T3.`lastNameOtherLanguage` AS STUDENT_LAST_NAME_OTHER_LANGUAGE
    FROM
	users T1
		LEFT JOIN
    students T2 ON T1.id = T2.userId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
	    LEFT JOIN
	admission T4 ON T2.userId = T4.studentId
        LEFT JOIN
    prog_batch_seat_config T5 ON T4.programBatchSeatConfigId = T5.id 
        LEFT JOIN
    batches T6 ON T6.id=T5.programBatchId
        LEFT JOIN
    programs T7 ON T7.id = T6.programId
	    LEFT JOIN
    seat_types T8 ON T5.seatTypeId = T8.id
WHERE
    T1.id IN (namedParams) and T4.activeStatus=true order by T4.id desc limit 1
",
jsonString = '{
  "id": 1,
  "searchResultViewColumns": [
    {
      "id": 1,
      "value": "id",
      "resultKey": "ID",
      "displayCode": "",
      "displayOrder": 0
    },
    {
      "id": 2,
      "value": "printName",
      "resultKey": "PRINT_NAME",
      "displayCode": "",
      "displayOrder": 1
    },
    {
      "id": 3,
      "value": "firstName",
      "resultKey": "FIRST_NAME",
      "displayCode": "",
      "displayOrder": 2
    },
    {
      "id": 4,
      "value": "middleName",
      "resultKey": "MIDDLE_NAME",
      "displayCode": "",
      "displayOrder": 3
    },
    {
      "id": 5,
      "value": "lastName",
      "resultKey": "LAST_NAME",
      "displayCode": "",
      "displayOrder": 4
    },
    {
      "id": 6,
      "value": "code",
      "resultKey": "STUDENT_CODE",
      "displayCode": "",
      "displayOrder": 5
    },
    {
      "id": 7,
      "value": "Current Date",
      "resultKey": "CURRENT_DATE_TODAY",
      "displayCode": "",
      "displayOrder": 6
    },
    {
      "id": 8,
      "value": "externalSysRefOne",
      "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
      "displayCode": "",
      "displayOrder": 7
    },
    {
      "id": 9,
      "value": "programNameToBePrint",
      "resultKey": "PROGRAM",
      "displayCode": "",
      "displayOrder": 8
    },
    {
      "id": 10,
      "value": "programNameToBePrintLanguageOne",
      "resultKey": "PROGRAM_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 9
    },
    {
      "id": 11,
      "value": "printName",
      "resultKey": "BATCH",
      "displayCode": "",
      "displayOrder": 10
    },
    {
      "id": 12,
      "value": "seatName",
      "resultKey": "SEAT_TYPE",
      "displayCode": "",
      "displayOrder": 11
    },
    {
      "id": 13,
      "value": "seatNameOtherLanguage",
      "resultKey": "SEAT_TYPE_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 12
    },
    {
      "id": 14,
      "value": "printNameOtherLanguage",
      "resultKey": "STUDENT_PRINT_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 13
    },
    {
      "id": 15,
      "value": "firstNameOtherLanguage",
      "resultKey": "STUDENT_FIRST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 14
    },
    {
      "id": 16,
      "value": "middleNameOtherLanguage",
      "resultKey": "STUDENT_MIDDLE_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 15
    },
    {
      "id": 17,
      "value": "lastNameOtherLanguage",
      "resultKey": "STUDENT_LAST_NAME_OTHER_LANGUAGE",
      "displayCode": "",
      "displayOrder": 16
    }
  ]
}'

WHERE dataProviderId = @dtproviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20240916115145__Update_StatementOfAccountAdhocEvent () $$
DROP PROCEDURE IF EXISTS V20240916115145__Update_StatementOfAccountAdhocEvent $$
DELIMITER ;