DELIMITER $$
DROP PROCEDURE IF EXISTS V20241001162111__Create_execution_details_RA_outcome $$
CREATE PROCEDURE V20241001162111__Create_execution_details_RA_outcome()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='execution_details_readmission_outcome') THEN 
CREATE TABLE `execution_details_readmission_outcome` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `executionDetailId` BIGINT NULL,
  `readmissionOutcomeId` BIGINT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

  PRIMARY KEY (`id`),
  CONSTRAINT `execution_detail_foeign_key`
    FOREIGN KEY (`executionDetailId`)
    REFERENCES `execution_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_execution_details_readmission_outcome_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,  
  CONSTRAINT `readmission_outcome_foreign_key`
    FOREIGN KEY (`readmissionOutcomeId`)
    REFERENCES `readmission_outcome` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20241001162111__Create_execution_details_RA_outcome () $$ 
DROP PROCEDURE IF EXISTS V20241001162111__Create_execution_details_RA_outcome $$ 
DELIMITER ;