DELIMITER $$
DROP PROCEDURE IF EXISTS V20241007115104__Create_progcatgroupcourseLMS $$
CREATE PROCEDURE V20241007115104__Create_progcatgroupcourseLMS()
BEGIN

IF EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='prog_cat_group_courses') THEN 
drop view prog_cat_group_courses;
END IF; 
CREATE 
VIEW prog_cat_group_courses AS
    SELECT 
        cv.id AS id,
        p.academyLocationId AS academy_location_id,
        pc.id AS prog_cat_id,
        pc.categoryName AS prog_cat_name,
        pc.lastUpdate AS prog_cat_lastupdate,
        mpcat.moodleId AS prog_cat_moodleid,
        mpcat.parentMoodleId AS prog_cat_parent_moodleid,
        pg.id AS prog_group_id,
        pg.groupName AS prog_group_name,
        pg.lastUpdate AS prog_group_lastupdate,
        mpgroup.moodleId AS prog_group_moodleid,
        mpgroup.parentMoodleId AS prog_group_parent_moodleid,
        p.id AS prog_id,
        p.programCode AS prog_code,
        p.programName AS prog_name,
        p.lastUpdate AS prog_lastupdate,
        mprog.moodleId AS prog_moodleid,
        mprog.parentMoodleId AS prog_parent_moodleid,
        aterm.id AS academic_term_id,
        aterm.itemValue AS academic_term_name,
        aterm.lastUpdate AS academic_term_lastupdate,
        macadtrm.moodleId AS academic_term_moodleid,
        macadtrm.parentMoodleId AS academic_term_parent_moodleid,
        c.id AS course_id,
        c.courseCode AS course_code,
        c.courseName AS course_name,
        c.lastUpdate AS course_lastupdate,
        mc.moodleId AS course_moodleid,
        mc.parentMoodleId AS course_parent_moodleid,
        cv.id AS course_variant_id,
        param.sectionId AS section_id,
        cv.courseVariantCode AS course_variant_name,
        cv.lastUpdate AS course_variant_lastupdate,
        mcv.moodleCourseId AS course_variant_moodleid,
        mcv.parentMoodleId AS course_variant_parent_moodleid
    FROM
        ((((((((((((((program_batch_course_param param
        JOIN batches b ON ((param.programBatchId = b.id)))
        JOIN prog_batch_period_config period ON (((param.progBatchPeriodConfigId = period.id)
            AND (period.programBatchId = b.id))))
        JOIN academic_term aterm ON ((period.academicTermId = aterm.id)))
        JOIN programs p ON ((b.programId = p.id)))
        JOIN program_group pg ON ((p.programGroupId = pg.id)))
        JOIN program_category pc ON ((p.programCategoryId = pc.id)))
        JOIN courses c ON ((param.courseId = c.id)and (c.isLMSCourses = true)))
        JOIN course_variants cv ON (((param.courseVarientId = cv.id)
            AND (cv.courseId = c.id)
            AND (p.academyLocationId = cv.academyLocationId))))
        LEFT JOIN moodle_transaction_info mpcat ON (((mpcat.academiaId = pc.id)
            AND (mpcat.moodleTransactionType = 'PROGRAM_CATEGORY')
            AND (mpcat.hierarchy = 'CAT_GROUP_PROGRAM_ACADEMICTERM_COURSE_VARIANT'))))
        LEFT JOIN moodle_transaction_info mpgroup ON (((mpgroup.academiaId = pg.id)
            AND (mpgroup.parentAcademiaId = pc.id)
            AND (mpcat.hierarchy = mpgroup.hierarchy)
            AND (mpgroup.moodleTransactionType = 'PROGRAM_GROUP'))))
        LEFT JOIN moodle_transaction_info mprog ON (((mprog.academiaId = p.id)
            AND (mprog.parentAcademiaId = pg.id)
            AND (mpgroup.hierarchy = mprog.hierarchy)
            AND (mprog.moodleTransactionType = 'PROGRAM'))))
        LEFT JOIN moodle_transaction_info macadtrm ON (((macadtrm.academiaId = aterm.id)
            AND (macadtrm.parentAcademiaId = p.id)
            AND (mprog.hierarchy = macadtrm.hierarchy)
            AND (macadtrm.moodleTransactionType = 'ACADEMIC_TERM'))))
        LEFT JOIN moodle_transaction_info mc ON (((mc.academiaId = c.id)
            AND (mc.parentAcademiaId = aterm.id)
            AND (macadtrm.hierarchy = mc.hierarchy)
            AND (mc.moodleTransactionType = 'COURSE'))))
        LEFT JOIN moodle_course mcv ON (((mcv.academiaCourseVariantId = cv.id)
            AND (mcv.sectionid = param.sectionId)
            AND (mcv.parentAcademiaId = c.id)
            AND (mc.hierarchy = mcv.hierarchy)
            AND (mcv.academyLocationId = p.academyLocationId))));
END $$
CALL V20241007115104__Create_progcatgroupcourseLMS () $$ 
DROP PROCEDURE IF EXISTS V20241007115104__Create_progcatgroupcourseLMS $$ 
DELIMITER ;