DELIMITER $$
DROP PROCEDURE IF EXISTS V20241007125223__Insert_GNA_SECTION_WISE_TIME_TABLE $$
CREATE PROCEDURE V20241007125223__Insert_GNA_SECTION_WISE_TIME_TABLE()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_SECTION_WISE' )) THEN 
set @master = (select id from report_type WHERE typeName = 'Timetable');

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_SECTION_WISE')) THEN 
INSERT INTO report_template (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@master, 'MASTER_TIME_TABLE_SECTION_WISE', 'Master Time Table - Section Wise', 'MASTER_TIME_TABLE_SECTION_WISE.png', 'MASTER_TIME_TABLE_SECTION_WISE_CommonReport.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'MASTER_TIME_TABLE_SECTION_WISE.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_SECTION_WISE')) THEN 
set @table1 = (select max(id) from `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_SECTION_WISE');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_TIMETABLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_TIMETABLE', 'Timetable', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_FACULTY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_FACULTY', 'Faculty', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_PROGRAM', 'Program', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_BATCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_BATCH', 'Batch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_PERIOD', 'Period', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_SECTION_GROUP')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_SECTION_GROUP', 'Section Group', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_SESSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_SESSION', 'Session', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @table1 and keyValue='TRANS_DAY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@table1, 'TRANS_DAY', 'Day/Session', '1', now());
END IF;

END IF;

END $$
CALL V20241007125223__Insert_GNA_SECTION_WISE_TIME_TABLE() $$
DROP PROCEDURE IF EXISTS V20241007125223__Insert_GNA_SECTION_WISE_TIME_TABLE $$
DELIMITER ;