DELIMITER $$
DROP PROCEDURE IF EXISTS V20241016115823__Create_sceqde $$
CREATE PROCEDURE V20241016115823__Create_sceqde()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_course_enrollment_Queue_details_entry')) THEN 
CREATE TABLE `student_course_enrollment_Queue_details_entry` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `studentCourseEnrollmentId` bigint DEFAULT NULL,
  `programBatchCourseDetailsId` bigint DEFAULT NULL,
  `admissionId` bigint DEFAULT NULL,
  `studentId` bigint DEFAULT NULL,
  `version` BIGINT NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_sceqde_studentCourseEnrollmentId_idx` (`studentCourseEnrollmentId` ASC),
  INDEX `fk_sceqde_programBatchCourseDetailsId_idx` (`programBatchCourseDetailsId` ASC),
  INDEX `fk_sceqde_admissionId_idx` (`admissionId` ASC),
  INDEX `fk_sceqde_studentId_idx` (`studentId` ASC),
  INDEX `fk_sceqde_lastUpdated_idx` (`lastUpdatedBy` ASC),

  CONSTRAINT `fk_sceqde_studentCourseEnrollmentId` 
	FOREIGN KEY (`studentCourseEnrollmentId`)
	REFERENCES `student_course_enrollment` (`id`),
  CONSTRAINT `fk_sceqde_programBatchCourseDetailsId` 
	FOREIGN KEY (`programBatchCourseDetailsId`) 
	REFERENCES `prog_batch_course_details` (`id`) ,
  CONSTRAINT `fk_sceqde_admissionId` 
	FOREIGN KEY (`admissionId`) 
	REFERENCES `admission` (`id`) ,
   CONSTRAINT `fk_sceqde_studentId`
   FOREIGN KEY (`studentId`)
   REFERENCES students (userId),
  CONSTRAINT `fk_sceqde_lastUpdated` 
	FOREIGN KEY (`lastUpdatedBy`) 
	REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION);
  END IF; 

END $$
CALL V20241016115823__Create_sceqde () $$ 
DROP PROCEDURE IF EXISTS V20241016115823__Create_sceqde $$ 
DELIMITER ;