DELIMITER $$
DROP PROCEDURE IF EXISTS V20241017224041__Update_EscalatedOfferReviewAfterAcceptance $$
CREATE PROCEDURE V20241017224041__Update_EscalatedOfferReviewAfterAcceptance()
BEGIN
set  @dtprovider=(select id from dtprovider where dataProviderName="ESCALATED_OFFER_REVIEWED_AFTER_ACCEPTANCE_RECIPIENTS");
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from sql_dtprovider where dataProviderId=@dtprovider)) THEN 
UPDATE sql_dtprovider 
SET sqlQuery = "SELECT 
      T1.id AS ID,
      T6.code AS APPLICATION_CODE,
      T6.currentStatus AS APPLICATION_STATUS,
      T10.printName AS USER_PRINT_NAME,
      T10.firstName AS FIRST_NAME,
      T10.lastName AS LAST_NAME,
      T7.printName AS APPLICANT_NAME,
      T1.reassignDate AS ESCALATED_RE_ASSIGN_DATE,
      T1.escalationComments AS ESCALATION_RE_ASSIGN_REMARK,   
      T10.emailId AS EMAIL_ID,
      T12.mobileNumber AS MOBILE_NO,
      T4.programName AS PROGRAM_NAME,
      T8.batchName AS BATCH_PRINT_NAME,
      T9.seatName AS SEAT_TYPE,
      T5.academyName AS ACADEMY_NAME,
      T5.locationName AS LOCATION_NAME,
      T5.displayName AS ACADEMY_NAME_LOCATION,    
      (CASE
          WHEN
              T5.headerUrl IS NOT NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl, '/', T5.headerUrl)
          ELSE NULL
      END) AS HEADER_URL,
      (CASE
          WHEN
              T5.footerUrl IS NOT NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl, '/', T5.footerUrl)
          ELSE NULL
      END) AS FOOTER_URL,
      (CASE
          WHEN
              T5.logoUrl IS NULL
                  AND org.orgUrl IS NOT NULL
          THEN
              CONCAT(org.orgUrl,
                      '/',
                      'emailer/images/logo_default_image.png')
          WHEN
              T5.logoUrl IS NULL
                  AND org.orgUrl IS NULL
          THEN
              'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
          ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
      END) AS LOGO_URL
  FROM
      app_program_adm_details T1
          LEFT OUTER JOIN
      application_program T2 ON T1.applicationProgramId = T2.id
          LEFT OUTER JOIN
      prog_batch_seat_config T3 ON T2.progBatchSeatConfigId = T3.id
          LEFT OUTER JOIN
      programs T4 ON T2.programId = T4.id
          LEFT OUTER JOIN
      academy_location T5 ON T2.academyLocationId = T5.id
          LEFT OUTER JOIN
      application T6 ON T2.applicationId = T6.id
          LEFT OUTER JOIN
      applicant_person T7 ON T6.applicantPersonId = T7.id
          LEFT OUTER JOIN
      batches T8 ON T8.id = T3.programBatchId
          LEFT OUTER JOIN
      seat_types T9 ON T9.id = T3.seatTypeId
          LEFT OUTER JOIN
      users T10 ON T1.firstEscalatedBy = T10.id
          LEFT  JOIN
          staffs T11 ON T11.userId = T10.id
          LEFT  JOIN
             persons T12 ON T12.id = T11.personId
          LEFT OUTER JOIN
      organizations org ON org.id = (SELECT 
              MAX(id)
          FROM
              organizations)
  WHERE
      T1.id IN (namedParams);"
, jsonString ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "reassignDate",
            "resultKey": "ESCALATED_RE_ASSIGN_DATE",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "escalationComments",
            "resultKey": "ESCALATION_RE_ASSIGN_REMARK",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		 {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },	
        {
            "id": 6,
            "value": "printName",
            "resultKey": "APPLICANT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 12
        },		
		{
            "id": 14,
            "value": "headerURL",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "footerURL",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "printName",
            "resultKey": "USER_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' 
WHERE dataProviderId=@dtprovider;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241017224041__Update_EscalatedOfferReviewAfterAcceptance () $$
DROP PROCEDURE IF EXISTS V20241017224041__Update_EscalatedOfferReviewAfterAcceptance $$
DELIMITER ;