DELIMITER $$
DROP PROCEDURE IF EXISTS V20241107150607__Update_InactiveAdmissionDataProvider $$
CREATE PROCEDURE V20241107150607__Update_InactiveAdmissionDataProvider()
BEGIN
    SET SQL_SAFE_UPDATES = 0;
    IF EXISTS (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers') THEN
        SET @dydtdataproviderId = (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers');
        UPDATE dydt_data_line_item
        SET 
            sqlSelectQueryDef = 'SELECT 
                learning_allowance.validForm AS VALID_FROM,
                GROUP_CONCAT(learning_allowances_csm.itemValue) AS LEARNING_ALLOWANCE 
            FROM 
                learning_allowance
            LEFT JOIN 
                persons ON persons.id = learning_allowance.personId
            LEFT JOIN 
                learning_allowance_csm_mapping ON learning_allowance_csm_mapping.learning_allowance_id = learning_allowance.id
            LEFT JOIN 
                learning_allowances_csm ON learning_allowances_csm.id = learning_allowance_csm_mapping.learning_allowance_CSM_Id',
            resultColumnsDef = 'VALID_FROM, LEARNING_ALLOWANCE'
        WHERE 
            dataSourceCode = 'INACTIVE_ADMISSION_DATA_PROVIDERS'
            AND dataProviderId = @dydtdataproviderId;
    END IF;
    
    SET SQL_SAFE_UPDATES = 1;
    SET @dataLineItemId = (SELECT id FROM dydt_data_line_item WHERE dataSourceCode = 'INACTIVE_ADMISSION_DATA_PROVIDERS');

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId=@dataLineItemId and translationCode='LEARNING_ALLOWANCE') THEN
    INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId)
    VALUES ('LEARNING_ALLOWANCE', 'Learning Allowance', @dataLineItemId);
END IF;


IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId=@dataLineItemId and translationCode='VALID_FROM') THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('VALID_FROM', 'Valid From', @dataLineItemId);
END IF;

END $$
CALL V20241107150607__Update_InactiveAdmissionDataProvider() $$
DROP PROCEDURE IF EXISTS V20241107150607__Update_InactiveAdmissionDataProvider $$
DELIMITER ;
