DELIMITER $$
DROP PROCEDURE IF EXISTS V20241107223552__Create_completionDataProviderForPassOut $$
CREATE PROCEDURE V20241107223552__Create_completionDataProviderForPassOut()
BEGIN

IF NOT EXISTS ((SELECT id FROM `dydt_data_provider` where providerName='Completion Data Providers For Pass Out')) THEN 
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Completion Data Providers For Pass Out', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='Completion Data Providers For Pass Out');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'COMPLETIONS_DATA_PROVIDER_FOR_PASSOUT', '1',null, '1', '1', 
'SELECT   DATE_FORMAT(T1.effectiveDate, "%M %Y") AS PASSOUT_EFFECTIVE_MONTH_YEAR
from completions T1 
LEFT OUTER JOIN admission T2 ON T1.admissionId=T2.id', 'PRM_ADMISSION_ID', 
'PASSOUT_EFFECTIVE_MONTH_YEAR',
'WHERE T1.completionCategory="Passing Out"  and T2.id=PRM_ADMISSION_ID order by T1.id desc limit 1', '0');

 INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
 VALUES ('PASSOUT_EFFECTIVE_MONTH_YEAR', 'Pass out Month Year',@dydtdatalinitemId+1);

END IF;

END $$
CALL V20241107223552__Create_completionDataProviderForPassOut () $$ 
DROP PROCEDURE IF EXISTS V20241107223552__Create_completionDataProviderForPassOut $$ 
DELIMITER ;