DELIMITER $$
DROP PROCEDURE IF EXISTS V20241126124127__Insert_BUZZ_Degree_Report $$
CREATE PROCEDURE V20241126124127__Insert_BUZZ_Degree_Report()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS (SELECT * from report_template where templateCode='BUZZ_DEGREE_AUDIT_REPORT' and templateName='Buzz Degree Audit Report') THEN 
	
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,`templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'BUZZ_DEGREE_AUDIT_REPORT', 'Buzz Degree Audit Report', 'BUZZ_DEGREE_AUDIT_REPORT.png', 'BUZZ_DEGREE_AUDIT_REPORT_COMMONREPORT.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'BUZZ_DEGREE_AUDIT_REPORT.jasper', 'AcademiaLogo.png');

END IF;

set @tempId = (select max(id) from report_template where templateCode='BUZZ_DEGREE_AUDIT_REPORT' and templateName='Buzz Degree Audit Report');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DATE', 'Date:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DAR', 'Degree Audit Report', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_STD_NAME', 'STUDENT NAME:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NUMBER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_STD_NUMBER', 'STUDENT NUMBER:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ID_PASSPORT_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_ID_PASSPORT_NO', 'ID/PASSPORT NUMBER:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NQF_LEVEL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_NQF_LEVEL', 'NQF LEVEL', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MIN_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MIN_CREDITS', 'MINIMUM CREDITS', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SAQA_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_SAQA_ID', 'SAQA ID', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REG_YEAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_REG_YEAR', 'Reg Year', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_WEIGHTING') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_WEIGHTING', 'Weighting', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CASS_MET') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CASS_MET', 'Cass Met', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OBTAINED_MARK') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_OBTAINED_MARK', 'Obtained Mark %', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SYMBOL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_SYMBOL', 'Symbol', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_RPD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_RPD', 'Result Publish Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_RESULTS_CODE_KEY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_RESULTS_CODE_KEY', 'RESULTS CODE/KEY:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NOTE1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_NOTE1', '** Results are provisionally released and may be subject to change.', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NOTE2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_NOTE2', 'PD (Pass with Distinction) | P (Pass) | F (Fail) | FES (Failed Examination Subminimum, failed overall) | IC (Academic Credit - Internal) |
EC (Academic Credit - External) | ECC (Exempt due to Curriculum Change) | SUPP (Supplementary Exam) | DNQ (Did Not Qualify for Examination Entry) | E (Endorsed) | NE
(Not Endorsed) | OS (Outstanding) | Pre-2022 Results Code CD (Condoned Distinction) | CP (Condoned Pass)', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REGISTRAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_REGISTRAR', 'Registrar (The Independent Institute of Education (Pty) Ltd)', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PAGE_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_PAGE_NO', 'Page', '1', now());
END IF;

END $$
CALL V20241126124127__Insert_BUZZ_Degree_Report() $$
DROP PROCEDURE IF EXISTS V20241126124127__Insert_BUZZ_Degree_Report $$
DELIMITER ;