DELIMITER $$
DROP PROCEDURE IF EXISTS V20241126150045__Alter_AddColAccSetupToAllowedSch $$
CREATE PROCEDURE V20241126150045__Alter_AddColAccSetupToAllowedSch()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='allowed_scholarship' AND column_name='parentScholarshipId')) THEN 

ALTER TABLE `allowed_scholarship` DROP FOREIGN KEY `allowed_scholarship_ibfk_2`; 
ALTER TABLE `allowed_scholarship` DROP COLUMN `parentScholarshipId`;

TRUNCATE TABLE allowed_scholarship;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='awardWithOther')) THEN 

ALTER TABLE `scholarship` DROP COLUMN `awardWithOther`;

END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship_accounting_setup' AND column_name='awardWithOther')) THEN 

ALTER TABLE `scholarship_accounting_setup` ADD COLUMN `awardWithOther` VARCHAR(255) NULL DEFAULT NULL;

END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='allowed_scholarship' AND column_name='scholarshipAccountingSetupId')) THEN 

ALTER TABLE `allowed_scholarship` ADD COLUMN `scholarshipAccountingSetupId` BIGINT(20) NOT NULL AFTER `allowedscholarshipId`,
ADD CONSTRAINT `allowed_scholarship_schAccSetupId_FK` FOREIGN KEY (`scholarshipAccountingSetupId`) REFERENCES `scholarship_accounting_setup`(`id`),
ADD CONSTRAINT `allowed_scholarship_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);

END IF;

END $$
CALL V20241126150045__Alter_AddColAccSetupToAllowedSch() $$
DROP PROCEDURE IF EXISTS V20241126150045__Alter_AddColAccSetupToAllowedSch $$
DELIMITER ;