DELIMITER $$
DROP PROCEDURE IF EXISTS V20241127105153__Create_xeroUserMapping $$
CREATE PROCEDURE V20241127105153__Create_xeroUserMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='xero_user_mapping')) THEN 
CREATE TABLE `xero_user_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `xeroContactId` varchar(255) NOT NULL,
  `academiaUserId` bigint NOT NULL,
  `academyLocationId` bigint NOT NULL,
  `isActive` bit(1) NOT NULL DEFAULT b'1',
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_xero_user_mapping_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_xero_user_mapping_academiaUserId_idx` (`academiaUserId`),
  KEY `fk_xero_user_mapping_academyLocationId_idx` (`academyLocationId`),
  CONSTRAINT `fk_xero_user_mapping_academiaUserId` FOREIGN KEY (`academiaUserId`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_xero_user_mapping_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_xero_user_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB ;

END IF;

END $$
CALL V20241127105153__Create_xeroUserMapping () $$ 
DROP PROCEDURE IF EXISTS V20241127105153__Create_xeroUserMapping $$ 
DELIMITER ;