DELIMITER $$
DROP PROCEDURE IF EXISTS V20241204113339__Create_xeroInvoiceMapping $$
CREATE PROCEDURE V20241204113339__Create_xeroInvoiceMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='xero_invoice_mapping')) THEN 
CREATE TABLE xero_invoice_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    xeroInvoiceId varchar(255) NOT NULL,
	invoiceNumber varchar(255) NOT NULL,
    academiaBillHeaderId bigint NOT NULL,
    xeroInvoiceType varchar(255) NOT NULL,
	lineAmount double default NULL,
    xeroUserId varchar(255) NOT NULL,
    academiaUserId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
	error TEXT default NULL,
    xeroStatus varchar(255) default null,
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_xero_invoice_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_xero_invoice_mapping_academiaBillHeaderId_idx (academiaBillHeaderId),
  KEY fk_xero_invoice_mapping_academiaUserId_idx (academiaUserId),
  KEY fk_xero_invoice_mapping_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_xero_invoice_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_xero_invoice_mapping_academiaBillHeaderId FOREIGN KEY (academiaBillHeaderId) REFERENCES bill_header (id),
  CONSTRAINT fk_xero_invoice_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id),
  CONSTRAINT fk_xero_invoice_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
  ) ENGINE=InnoDB;
END IF; 


END $$
CALL V20241204113339__Create_xeroInvoiceMapping () $$ 
DROP PROCEDURE IF EXISTS V20241204113339__Create_xeroInvoiceMapping $$ 
DELIMITER ;