DELIMITER $$
DROP PROCEDURE IF EXISTS V20241224113630__Create_Course_fee_refundrule_bills $$
CREATE PROCEDURE V20241224113630__Create_Course_fee_refundrule_bills()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_fee_refundrule_bills' )) THEN 
CREATE TABLE course_fee_refundrule_bills (
id bigint(20) NOT NULL AUTO_INCREMENT,
sceId bigint(20) DEFAULT NULL,
admissionId bigint(20) DEFAULT NULL,
studentId bigint(20) DEFAULT NULL,
courseId bigint(20) DEFAULT NULL,
periodId bigint(20) DEFAULT NULL,
transactionType varchar(30) DEFAULT NULL,
enrollmentBillId bigint(20) DEFAULT NULL,
refundBillId bigint(20) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (id),
FOREIGN KEY (sceId) REFERENCES student_course_enrollment (id),
FOREIGN KEY (enrollmentBillId) REFERENCES bill_header (id),
FOREIGN KEY (courseId) REFERENCES courses (id),
FOREIGN KEY (periodId) REFERENCES prog_batch_period_config (id),
FOREIGN KEY (refundBillId) REFERENCES bill_header (id),
FOREIGN KEY (admissionId) REFERENCES admission (id),
FOREIGN KEY (studentId) REFERENCES students (userId),
FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
);
END IF; 

END $$
CALL V20241224113630__Create_Course_fee_refundrule_bills () $$ 
DROP PROCEDURE IF EXISTS V20241224113630__Create_Course_fee_refundrule_bills $$ 
DELIMITER ;