DROP procedure IF EXISTS `setStudentJourneyAttributes`;
DELIMITER $$
CREATE PROCEDURE `setStudentJourneyAttributes`()
BEGIN
truncate student_journey_attributes;
Insert into student_journey_attributes (studentJourneyId, attributeCode,attributeValue, lastUpdated)
select 
	main.id,
    'Returning_From' as attributeCode,
	concat(al.locationCode,' ',pr.programCode,'-',pbpc.printname) as attributeValue,
    now() as timestamp
from 
(select 
 sj.id,
 sj.studentId,
 u.code,
 u.firstname,
 u.lastname,
 u.emailId,
 ate.itemValue as academicTerm,
 al.locationCode as academyLocation,
 pr.programCode,
 pbpc.printName as period,
 campus.value as campus,
 sj.resultStatus,
 sj.periodStatus,
 max(ate3.itemValue) as wasHereIn,
 max(sj2.itemValue) as previous_AcademicTerm
 from
student_journey sj
inner join users u 
on u.id = sj.studentId
inner join prog_batch_period_config pbpc
on pbpc.id = sj.periodid
inner join academy_location al
on al.id = sj.academyLocationId
inner join programs pr 
on pr.id = sj.programid
inner join academic_term ate
on ate.id = sj.academicTermId
left outer join academy_location_campus alc
on alc.id = sj.academyCampusId
inner join drop_down campus 
on campus.id = alc.campusId
inner join 
(
select sj.studentId,ate.itemValue
from student_journey sj
inner join academic_term ate
on ate.id = sj.academicTermId
where sj.isActive = 1)
sj2 
on sj2.studentId = sj.studentId
and sj2.itemValue < ate.itemValue
left outer join student_journey sj3
on sj3.studentid = sj.studentid
and sj3.isActive = 1 
and sj3.academylocationid = sj.academylocationid
left outer join academic_term ate3
on ate3.id = sj3.academicTermId
and ate3.ItemValue < ate.itemValue
where 
  sj.isActive = 1
group by sj.studentid
) main
inner join student_journey sj
on sj.studentId = main.studentId
and sj.isActive = 1
inner join academic_term ate
on ate.id = sj.academicTermid
and ate.itemValue = main.previous_AcademicTerm 
inner join programs pr 
on pr.id = sj.programid
inner join academy_location al 
on al.id = sj.academyLocationId
inner join prog_batch_period_config pbpc
on pbpc.id = sj.periodid
 where pr.programCode <> main.programCode;

END$$

DELIMITER ;