DELIMITER $$
DROP PROCEDURE IF EXISTS V20250113193956__Update_STUCOURSEENROLL_INFOData $$
CREATE PROCEDURE V20250113193956__Update_STUCOURSEENROLL_INFOData()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' limit 1)) THEN 
SET @dtProviderId=(select MAX(id) from dydt_data_line_item where dataSourceCode="STUDENT_COURSE_ENROLLMENT_INFO");
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef` = 'SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,\n    IFNULL(co.courseName, c.courseName) AS COURSE_NAME,\nFLOOR ( c.courseCredits) \nAS COURSE_CREDITS, \npbpc.printName AS PERIOD , ss.examDate AS EXAM_DATE, \nDATE_FORMAT(ss.examStartTime,\'%h:%i %p\') AS EXAM_START_TIME, \nDATE_FORMAT(ss.examEndTime,\'%h:%i %p\') \nAS EXAM_END_TIME,IF(program_courses.isOfferedYearly = 1,\n        \'Yes\',\n        \'No\') AS YEARLY_MODULE\nfrom student_course_enrollment sce\ninner \njoin prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id\ninner join period_year py on pbpc.periodYearId=py.id\ninner \njoin admission adm on adm.id=sce.admissionId\ninner join course_variants cv on cv.id=sce.courseVarientId\nINNER JOIN sections ss on ss.id = sce.sectionId\n\nleft join courses c on c.id=cv.courseId\nLEFT JOIN courses co ON co.id = c.parentCourseId\nLEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId AND pbpc.programBatchId = program_courses.programBatchId ', `sqlWhereQueryDef` = 'where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(\n CASE \n        WHEN adm.activeStatus=true\n            THEN\n                (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and \npbs.exitDate is null)\n            ELSE\n                (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )\n            END\n) and sce.exitDate is null group by sce.courseVarientId union all\nSELECT \n\'Total\' AS TOTAL,\n    COALESCE(SUM(COALESCE(c.courseCredits, 0)), 0) AS COURSE_CREDITS_TOTAL,\n    COALESCE(SUM(COALESCE(lp.topics, 0)), 0) AS TEACHING_HOURS_TOTAL,\n    COALESCE(SUM(COALESCE(lp.term, 0)), 0) AS LEARNING_HOURS_TOTAL,\n    ss.examDate AS EXAM_DATE,\n    DATE_FORMAT(ss.examStartTime, \'%h:%i %p\') AS EXAM_START_TIME,\n    DATE_FORMAT(ss.examEndTime, \'%h:%i %p\') AS EXAM_END_TIME,\n    null AS YEARLY_MODULE\nfrom student_course_enrollment sce\ninner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id\ninner join admission adm on adm.id=sce.admissionId\ninner join course_variants cv on cv.id=sce.courseVarientId\nINNER JOIN sections ss on ss.id = sce.sectionId\n left join courses c on c.id=cv.courseId  \n left join lesson_plan lp on lp.courseId=cv.courseId and pbpc.academicTermId=lp.academicTermId where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(\n CASE \n        WHEN adm.activeStatus=true\n            THEN\n                (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and \npbs.exitDate is null)\n            ELSE\n                (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )\n            END\n) and sce.exitDate is null ' WHERE (`id` = @dtProviderId) and (`whetherPrimaryDataSource` = '0');
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250113193956__Update_STUCOURSEENROLL_INFOData () $$
DROP PROCEDURE IF EXISTS V20250113193956__Update_STUCOURSEENROLL_INFOData $$
DELIMITER ;