DELIMITER $$
DROP PROCEDURE IF EXISTS V20250124142958__Update_User_info_dataprovider_update $$
CREATE PROCEDURE V20250124142958__Update_User_info_dataprovider_update()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='USER_INFO')) THEN 
SET @residenceRCPNT=(select id from dydt_data_provider d WHERE d.providerName='USER_INFO_PROVIDER' limit 1);
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT T2.id AS ID,T5.`salutationName` AS salutation_name,T2.`firstName` AS first_name,
            T2.`middleName` AS middle_name,T2.`lastName` AS last_name,
            T3.`emailId` AS email_id,T3.`mobileNumber` AS mobile_number ,
            T3.`firstNameOtherLanguage` AS FIRST_NAME_OTHER_LANGUAGE,
    	    T3.`middleNameOtherLanguage` AS MIDDLE_NAME_OTHER_LANGUAGE,
            T3.`lastNameOtherLanguage` AS LAST_NAME_OTHER_LANGUAGE,
            T3.`shortNameOtherLanguage` AS SHORT_NAME_OTHER_LANGUAGE,
            T3.`printNameOtherLanguage` AS PRINT_NAME_OTHER_LANGUAGE,
    	    T5.`salutationNameInOtherLanguage` AS SALUTATION_NAME_OTHER_LANGUAGE,
    CASE WHEN T4.personId IS NULL THEN T1.personId ELSE T4.personID END 
    FROM persons T3
    LEFT JOIN students T4 ON T3.id = T4.personId
    LEFT JOIN staffs T1 ON T3.id =T1.personId
    LEFT JOIN `salutations` T5 ON T5.`id`=T3.`salutationId` 
    LEFT JOIN users T2 ON ( T4.userId = T2.id OR T1.userId = T2.id )',
    `resultColumnsDef` = 'salutation_name,first_name,middle_name,last_name,email_id,mobile_number,FIRST_NAME_OTHER_LANGUAGE,MIDDLE_NAME_OTHER_LANGUAGE,LAST_NAME_OTHER_LANGUAGE,SHORT_NAME_OTHER_LANGUAGE,PRINT_NAME_OTHER_LANGUAGE,SALUTATION_NAME_OTHER_LANGUAGE'
WHERE
   dataProviderId=@residenceRCPNT
        AND (`whetherPrimaryDataSource` = '1');
        
        #------------------TRANSLATIONS---------------------
        
        SET @dydtdatalinitemId=(select id from dydt_data_line_item where dataSourceCode='USER_INFO' limit 1);
   
	INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('FIRST_NAME_OTHER_LANGUAGE', 'First Name Other Language',@dydtdatalinitemId),
     ('MIDDLE_NAME_OTHER_LANGUAGE', 'Middle Name Other Language',@dydtdatalinitemId),
     ('LAST_NAME_OTHER_LANGUAGE', 'Last Name Other Language',@dydtdatalinitemId),
     ('SHORT_NAME_OTHER_LANGUAGE', 'Short Name Other Language',@dydtdatalinitemId),
     ('PRINT_NAME_OTHER_LANGUAGE', 'Print Name Other Language',@dydtdatalinitemId),
     ('SALUTATION_NAME_OTHER_LANGUAGE', 'Salutation Name Other Language',@dydtdatalinitemId);
        
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250124142958__Update_User_info_dataprovider_update () $$
DROP PROCEDURE IF EXISTS V20250124142958__Update_User_info_dataprovider_update $$
DELIMITER ;