DELIMITER $$
DROP PROCEDURE IF EXISTS V20250311131927__Update_ExamEmailMarksheetEvents $$
CREATE PROCEDURE V20250311131927__Update_ExamEmailMarksheetEvents()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T12.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
	   now() as PRINT_DATETIME,
    T12.`id` as JOB_ID,
 T30.`remarks` as REMARK

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join
            program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null  and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
               left join 
            sections  T27 on T27.id=T12.sectionId
            left join
            batches T10 on T10.id=T9.programBatchId
             left join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId
   WHERE
       T12.id IN (namedParams)  limit 1",
       jsonString='{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T1.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
	   T23.`date` as EVENT_DATE,
	   now() as PRINT_DATETIME,
    T12.`id` as JOB_ID,
 T30.`remarks` as REMARK

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join
             program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
            left join
            batches T10 on T10.id=T9.programBatchId
              left join 
            lesson_plan_course_variant as T20 on T17.courseVariantId=T20.courseVariantId
              left join  
            lesson_plan as T21 on T20.lessonPlanId=T21.id
              left join 
            lesson_plan_exam_detail as T22 on T21.id=T22.lessonPlanId
              left join 
            event_detail as T23 on T23.lpExamDetailId=T22.id
                  left join 
            sections  T27 on T27.id=T12.sectionId
            left join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId
   WHERE
       T12.admissionId IN (namedParams)  and  T17.status='FAIL'
      group by T19.id  ",
       jsonString='
      {
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
        {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T1.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
	   T23.`date` as EVENT_DATE,
	   now() as PRINT_DATETIME,
    T12.`id` as JOB_ID,
 T30.`remarks` as REMARK

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
             left join
           program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null  and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
            left join
            batches T10 on T10.id=T9.programBatchId
              left join 
            lesson_plan_course_variant as T20 on T17.courseVariantId=T20.courseVariantId
              left join  
            lesson_plan as T21 on T20.lessonPlanId=T21.id
              left join 
            lesson_plan_exam_detail as T22 on T21.id=T22.lessonPlanId
              left join 
            event_detail as T23 on T23.lpExamDetailId=T22.id
           left join 
            sections  T27 on T27.id=T12.sectionId
          left join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId
   WHERE
       T12.admissionId IN (namedParams)  and  T17.status='FAIL'
      group by T19.id  ",
       jsonString='{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T1.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
	   T23.`date` as EVENT_DATE,
	   now() as PRINT_DATETIME,
    T12.`id` as JOB_ID,
 T30.`remarks` as REMARK

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join
           program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
            left join
            batches T10 on T10.id=T9.programBatchId
              left join 
            lesson_plan_course_variant as T20 on T17.courseVariantId=T20.courseVariantId
              left join  
            lesson_plan as T21 on T20.lessonPlanId=T21.id
              left join 
            lesson_plan_exam_detail as T22 on T21.id=T22.lessonPlanId
              left join 
            event_detail as T23 on T23.lpExamDetailId=T22.id
             left join 
            sections  T27 on T27.id=T12.sectionId
           left join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId
   WHERE
       T12.admissionId IN (namedParams)  and  T17.status='FAIL'
      group by T19.id ",
       jsonString='{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T1.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
	   T23.`date` as EVENT_DATE,
	   now() as PRINT_DATETIME,
    T12.`id` as JOB_ID,
 T30.`remarks` as REMARK

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
             left join
            program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
            left join
            batches T10 on T10.id=T9.programBatchId
              left join 
            lesson_plan_course_variant as T20 on T17.courseVariantId=T20.courseVariantId
              left join  
            lesson_plan as T21 on T20.lessonPlanId=T21.id
              left join 
            lesson_plan_exam_detail as T22 on T21.id=T22.lessonPlanId
              left join 
            event_detail as T23 on T23.lpExamDetailId=T22.id
            left join 
            sections  T27 on T27.id=T12.sectionId
           left join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId
   WHERE
       T12.admissionId IN (namedParams)  and  T17.status='FAIL'
      group by T19.id ",
      jsonString='{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250311131927__Update_ExamEmailMarksheetEvents () $$
DROP PROCEDURE IF EXISTS V20250311131927__Update_ExamEmailMarksheetEvents $$
DELIMITER ;