DELIMITER $$

DROP PROCEDURE IF EXISTS V20250421125847__Create_Blooms_Tech_Levels_CSM $$

CREATE PROCEDURE V20250421125847__Create_Blooms_Tech_Levels_CSM()
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'blooms_taxonomy_level') THEN
        CREATE TABLE blooms_taxonomy_level (
            id BIGINT(20) NOT NULL AUTO_INCREMENT,
            levelCode VARCHAR(255) NOT NULL,
            levelName VARCHAR(255) NOT NULL,
            lastUpdatedBy BIGINT(20) NOT NULL,
            lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            FOREIGN KEY (lastUpdatedBy) REFERENCES users(id),
            UNIQUE KEY fk_level_code_idx (levelCode),
            UNIQUE KEY fk_level_name_idx (levelName)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        
        SET @currentTimeStamp = CURRENT_TIMESTAMP;
        SET @standardMasterMaxId = (SELECT IFNULL(MAX(id), 0) FROM standard_master);
        
        INSERT INTO standard_master(id, tableName, masterName, moduleName, filterCode, whetherChild, whetherParent, lastUpdatedBy, lastUpdate)
        VALUES (@standardMasterMaxId + 1, 'blooms_taxonomy_level', 'blooms_taxonomy_level', 'Examinations', 'COMMON_MASTER', 0, 0, 1, NOW());
        
        SET @ItemsMaxId = (SELECT IFNULL(MAX(id), 0) FROM standard_master_items);
        
        INSERT INTO standard_master_items(id, dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
        VALUES (@ItemsMaxId + 1, 'levelCode', 'Level Code', @standardMasterMaxId + 1, 'varchar', 1, 0, 0, 0, 0, 1, NOW());
        
        SET @ItemsMaxId = (SELECT IFNULL(MAX(id), 0) FROM standard_master_items);
        
        INSERT INTO standard_master_items(id, dbFieldName, fieldLabel, standardMasterId, fieldType, diaplayOrder, whetherForeignKey, whetherShortCode, whetherReadOnly, wheherNullable, lastUpdatedBy, lastUpdate)
        VALUES (@ItemsMaxId + 1, 'levelName', 'Level Name', @standardMasterMaxId + 1, 'varchar', 2, 0, 0, 0, 0, 1, NOW());
        
        IF NOT EXISTS (SELECT * FROM ui_translation WHERE objectName = 'masterNames' AND keyName = 'blooms_taxonomy_level') THEN
            INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage, lastUpdate, lastUpdatedBy)
            VALUES ('masterNames', 'blooms_taxonomy_level', 'Bloom''s Taxonomy Level', 'Bloom''s Taxonomy Level', 'Bloom se taksonomievlak', 'Mức độ phân loại của Bloom', NOW(), 1);
        END IF;
        
    END IF;
END $$

CALL V20250421125847__Create_Blooms_Tech_Levels_CSM() $$

DROP PROCEDURE IF EXISTS V20250421125847__Create_Blooms_Tech_Levels_CSM $$

DELIMITER ;