DELIMITER $$
DROP PROCEDURE IF EXISTS V20250422163433__Create_funding_and_monitoring $$
CREATE PROCEDURE V20250422163433__Create_funding_and_monitoring()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='funding_and_monitoring')) THEN 
CREATE TABLE funding_and_monitoring (
id bigint(20) NOT NULL AUTO_INCREMENT,
studentId BIGINT NOT NULL, 
programId bigint(20) DEFAULT NULL,
fundingBodyId bigint(20) DEFAULT NULL, 
nonRegulatedFeeFlagId bigint(20) DEFAULT NULL,
fundingLengthId bigint(20) DEFAULT NULL,
fundingCompletionId bigint(20) DEFAULT NULL,
equivalentOrLowerQualificationId bigint(20) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),
 INDEX fk_funding_and_monitoring_to_studentidx (studentId),
CONSTRAINT fk_funding_and_monitoring_to_studentidx FOREIGN KEY (studentId) REFERENCES students (userId),
CONSTRAINT `FK_funding_and_monitoring_FK_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
CONSTRAINT `FK_funding_and_monitoring_FK_fundingBodyId` FOREIGN KEY (`fundingBodyId`) REFERENCES `funding_body` (`id`),
CONSTRAINT `FK_funding_and_monitoring_FK_nonRegulatedFeeFlagId` FOREIGN KEY (`nonRegulatedFeeFlagId`) REFERENCES `non_regulated_fee_flag` (`id`),
CONSTRAINT `FK_funding_and_monitoring_FK_fundingLengthId` FOREIGN KEY (`fundingLengthId`) REFERENCES `funding_length` (`id`),
CONSTRAINT `FK_funding_and_monitoring_FK_fundingCompletionId` FOREIGN KEY (`fundingCompletionId`) REFERENCES `funding_completion` (`id`),
CONSTRAINT `FK_funding_and_monitoring_FK_equivalentOrLowerQualificationId` FOREIGN KEY (`equivalentOrLowerQualificationId`) REFERENCES `equivalent_or_lower_qualification` (`id`),
CONSTRAINT `FK_funding_and_monitoring_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;

END $$
CALL V20250422163433__Create_funding_and_monitoring () $$ 
DROP PROCEDURE IF EXISTS V20250422163433__Create_funding_and_monitoring $$ 
DELIMITER ;