DELIMITER $$

DROP PROCEDURE IF EXISTS sp_get_application_projection_by_id $$
CREATE PROCEDURE sp_get_application_projection_by_id(IN application_id BIGINT)
BEGIN
    SELECT
        this_.code AS applicationCode,
        this_.submissionDate AS applicationDate,
        this_.currentStatus AS applicationStatus,
        applicatio21_.printName AS applicationOwnerPrintName,
        applicanta7_.addressTypeId AS addressTypeId,
        applicanta7_.addressText AS streetAddress,
        countryreg17_.countryRegionName AS province,
        city19_.cityName AS city,
        applicanta7_.pincode AS postalCode,
        applicantp6_.id AS contactId,
        applicantp6_.nationalID AS nationalId,
        applicantp6_.externalSysRefThree AS apId,
        applicantp6_.firstName AS studentFirstName,
        applicantp6_.middleName AS studentMiddleName,
        applicantp6_.lastName AS studentSurname,
        applicantp6_.emergencyFirstName AS emergencyFirstName,
        applicantp6_.emergencyLastName AS emergencyLastName,
        applicantp6_.emergencyMobileCountryCode AS emergencyMobileCountryCode,
        applicantp6_.emergencyMobileNumber AS emergencyMobileNumber,
        applicantp6_.isLearnerSACitizen AS isStudentSaCitizen,
        applicantp6_.comments AS comment,
        gendercsm12_.itemValue AS gender,
        applicantp6_.birthDate AS studentDateOfBirth,
        nationalit10_.itemValue AS nationality,
        country18_.countryName AS country,
        homelangua8_.name AS homeLanguage,
        secondlang9_.name AS secondLanguage,
        religion11_.itemValue AS religion,
        currentedu13_.name AS currentEducationalInterventionsName,
        currentorl14_.itemValue AS currentOrLastSchoolAttendedValue,
        enquirysou3_.enquirySource AS enquirySource,

        (SELECT GROUP_CONCAT(d.value SEPARATOR ',')
         FROM applicant_person_disability apd
         LEFT JOIN drop_down d ON apd.haveDisabilityId = d.id
         WHERE apd.applicantpersonid = this_.applicantPersonId
        ) AS applicantPersonDisabilityNames,

        (SELECT GROUP_CONCAT(emode.itemValue SEPARATOR ',')
         FROM enquiry_multiple_mode emm
         JOIN enquiry_mode emode ON emm.enquiryModeId = emode.id
         WHERE emm.enquiryId = (
             SELECT esd.enquiryId
             FROM enq_student_details esd
             WHERE esd.id = this_.enquiryStudentDetailId
         )
        ) AS applicationEnquiryMultipleMode

    FROM
        application this_

    LEFT OUTER JOIN users applicatio21_ 
        ON this_.applicationOwner = applicatio21_.id 
    LEFT OUTER JOIN parents applicatio21_1_ 
        ON applicatio21_.id = applicatio21_1_.userId 
    LEFT OUTER JOIN staffs applicatio21_2_ 
        ON applicatio21_.id = applicatio21_2_.userId 
    LEFT OUTER JOIN students applicatio21_3_ 
        ON applicatio21_.id = applicatio21_3_.userId 
    LEFT OUTER JOIN enq_student_details enquirystu1_ 
        ON this_.enquiryStudentDetailId = enquirystu1_.id 
    LEFT OUTER JOIN enquiry enquiry2_ 
        ON enquirystu1_.enquiryId = enquiry2_.id 
    LEFT OUTER JOIN enquiry_multiple_mode applicatio4_ 
        ON enquiry2_.id = applicatio4_.enquiryId 
    LEFT OUTER JOIN enquiry_source enquirysou3_ 
        ON enquiry2_.enquirySourceId = enquirysou3_.id 
    LEFT OUTER JOIN applicant_person applicantp6_ 
        ON this_.applicantPersonId = applicantp6_.id 
    LEFT OUTER JOIN applicant_address applicanta7_ 
        ON applicantp6_.id = applicanta7_.applicantPersonId 
    LEFT OUTER JOIN address_type addresstyp16_ 
        ON applicanta7_.addressTypeId = addresstyp16_.id 
    LEFT OUTER JOIN city city19_ 
        ON applicanta7_.cityId = city19_.id 
    LEFT OUTER JOIN country country18_ 
        ON applicanta7_.countryId = country18_.id 
    LEFT OUTER JOIN country_region countryreg17_ 
        ON applicanta7_.parentRegionId = countryreg17_.id 
    LEFT OUTER JOIN applicant_person_disability applicantp15_ 
        ON applicantp6_.id = applicantp15_.applicantPersonId 
    LEFT OUTER JOIN drop_down havedisabi20_ 
        ON applicantp15_.haveDisabilityId = havedisabi20_.id 
    LEFT OUTER JOIN drop_down currentedu13_ 
        ON applicantp6_.currentEducationalInterventions = currentedu13_.id 
    LEFT OUTER JOIN campaign_school currentorl14_ 
        ON applicantp6_.currentOrLastSchoolAttended = currentorl14_.id 
    LEFT OUTER JOIN gender gendercsm12_ 
        ON applicantp6_.genderId = gendercsm12_.id 
    LEFT OUTER JOIN drop_down homelangua8_ 
        ON applicantp6_.homeLanguage = homelangua8_.id 
    LEFT OUTER JOIN nationalities nationalit10_ 
        ON applicantp6_.nationalityId = nationalit10_.id 
    LEFT OUTER JOIN religions religion11_ 
        ON applicantp6_.religionId = religion11_.id 
    LEFT OUTER JOIN drop_down secondlang9_ 
        ON applicantp6_.secondLanguage = secondlang9_.id 
    LEFT OUTER JOIN program_group programgro5_ 
        ON this_.programGroupId = programgro5_.id 

    WHERE
        this_.id = application_id
    GROUP BY
        this_.id, this_.enquiryStudentDetailId
    LIMIT 1;
END $$

DELIMITER ;
