DELIMITER $$
DROP PROCEDURE IF EXISTS V20250501141623__Update_Update_ATTESTATION_TABLE_ONE $$
CREATE PROCEDURE V20250501141623__Update_Update_ATTESTATION_TABLE_ONE()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_ONE")) THEN 
SET @dydtdatalinitemId=(select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_ONE");

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
        pbpc.printName AS PERIOD_NAME,
        pbpc.attestationLineOne AS ATTESTATION,
        CONCAT(CASE
                    WHEN
                        (SELECT 
                                ccourseCredits.ectsCredits
                            FROM
                                program_courses_period pcpcourseCredits
                                    JOIN
                                prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                    JOIN
                                program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                    JOIN
                                courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                            WHERE
                                pcpcourseCredits.periodId = pbpc.id
                                    AND ccourseCredits.ectsCredits IS NOT NULL
                                    AND ccourseCredits.ectsCredits > 0
                            LIMIT 1) > 0
                    THEN
                        "ECTS - Yes | "
                    ELSE "ECTS - No | "
                END,
                CASE
                    WHEN
                        (SELECT 
                                ccourseCredits.courseCredits
                            FROM
                                program_courses_period pcpcourseCredits
                                    JOIN
                                prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                    JOIN
                                program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                    JOIN
                                courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                            WHERE
                                pcpcourseCredits.periodId = pbpc.id
                                    AND ccourseCredits.courseCredits IS NOT NULL
                                    AND ccourseCredits.courseCredits > 0
                            LIMIT 1) > 0
                    THEN
                        "US - Yes"
                    ELSE "US - No"
                END) AS CREDIT
    FROM
        program_courses_period pcp
            JOIN
        prog_batch_period_config pbpc ON pbpc.id = pcp.periodId
            JOIN
        program_courses pc ON pc.id = pcp.programCourseId
            JOIN
        courses c ON c.id = pc.courseId
            JOIN
        student_journey sj ON sj.periodId = pcp.periodId'
WHERE
    (`id` = @dydtdatalinitemId);
END IF; 

IF EXISTS ((select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_TWO")) THEN 
SET @dydtdatalinitemId=(select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_TWO");

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'select pbpc.printName AS PERIOD_NAME,concat(pbpc.attestationLineOne,"<br></br><i>",pbpc.attestationLineTwo,"</i>") AS ATTESTATIONS from program_courses_period pcp
join prog_batch_period_config pbpc on pbpc.id=pcp.periodId
join program_courses pc on pc.id=pcp.programCourseId
join courses c on c.id=pc.courseId
join student_journey sj on sj.periodId=pcp.periodId'
WHERE
    (`id` = @dydtdatalinitemId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250501141623__Update_Update_ATTESTATION_TABLE_ONE () $$
DROP PROCEDURE IF EXISTS V20250501141623__Update_Update_ATTESTATION_TABLE_ONE $$
DELIMITER ;