DELIMITER $$
DROP PROCEDURE IF EXISTS V20250509170940__Create_VGUReceiptReport $$
CREATE PROCEDURE V20250509170940__Create_VGUReceiptReport()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt');

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_CODE' and `templateName`='VGU - Receipt')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_CODE', 'VGU - Receipt', 'VGUReceipt.png', 'CommonReport_VGU_RECEIPT.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'VGU_RECEIPT.jasper', 'AcademiaLogo.png');
END IF;

set @temp = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_RECEIPT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECEIPT', 'RECEIPT', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_OFFICE_COPY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_OFFICE_COPY', 'Office Copy', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_RECEIPT_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECEIPT_NO', 'Receipt No', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_RECEIPT_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECEIPT_DATE', 'Receipt Date', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_ID', 'ID', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_TITTLE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_TITTLE', 'Mr./Ms', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_S_D')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_S_D', 'S.o/D.o', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_CLASS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_CLASS', 'Class', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_RECIDENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECIDENT', 'Resident of', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PHON')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PHON', 'Phone', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_A_SUM_OF')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_A_SUM_OF', 'a sum of', '1', NOW()); 
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_DATE', 'Date', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_INVOICE_NUM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_INVOICE_NUM', 'Invoice Number', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PAYABLE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PAYABLE', 'Payable at', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_DRAWN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_DRAWN', 'Drawn on', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_REMARK')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_REMARK', 'Remark', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_AUTHORISED_SIGNATORY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_AUTHORISED_SIGNATORY', 'Authorised Signatory', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_THANK_YOU')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_THANK_YOU', 'Thank you.', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PAYMENTS_ACKNOWLEDGED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PAYMENTS_ACKNOWLEDGED', 'Cheques/DD and Credit/Debit Card payments acknowledged are subject to realisation', '1', NOW()); 
END IF;

END $$
CALL V20250509170940__Create_VGUReceiptReport () $$ 
DROP PROCEDURE IF EXISTS V20250509170940__Create_VGUReceiptReport $$ 
DELIMITER ;