DELIMITER $$
DROP PROCEDURE IF EXISTS V20250512214750__Create_ITT_Entry_Route $$
CREATE PROCEDURE V20250512214750__Create_ITT_Entry_Route()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='itt_entry_route')) THEN 
CREATE TABLE itt_entry_route(
    id BIGINT(20) NOT NULL AUTO_INCREMENT, 
    itemCode VARCHAR(255) NOT NULL ,
    itemValue VARCHAR(255) NOT NULL,
    lastUpdatedBy BIGINT(20)NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
    PRIMARY KEY (id),
    UNIQUE(itemCode),
    UNIQUE(itemValue)
    );
SET @currentTimeStamp = CURRENT_TIMESTAMP;    

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'itt_entry_route',' ITT Entry Route','General','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
END IF; 


END $$
CALL V20250512214750__Create_ITT_Entry_Route () $$ 
DROP PROCEDURE IF EXISTS V20250512214750__Create_ITT_Entry_Route $$ 
DELIMITER ;